/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class StaminaPillagerSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("20807880-fd30-11eb-9a03-0242ac130003");
    protected float regenPercentage;

    public StaminaPillagerSkill(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.regenPercentage = parameters.m_128457_("regen_rate");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.PLAYER_KILLED_EVENT, EVENT_UUID, event -> {
            float currentStamina = ((ServerPlayerPatch)event.getPlayerPatch()).getStamina();
            float staminaLoss = ((ServerPlayerPatch)event.getPlayerPatch()).getMaxStamina() - currentStamina;
            ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(currentStamina + Math.min(staminaLoss * this.regenPercentage * 0.01f, 2.0f));
            event.getKilledEntity().m_216990_((SoundEvent)EpicFightSounds.STAMINA_PILLAGER_DEATH.get());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPEntityPairingPacket(event.getKilledEntity().m_19879_(), EntityPairingPacketTypes.STAMINA_PILLAGER_BODY_ASHES), (Entity)event.getKilledEntity(), new Object[0]);
            SPEntityPairingPacket pairingPacket = new SPEntityPairingPacket(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_19879_(), EntityPairingPacketTypes.FLASH_WHITE);
            pairingPacket.getBuffer().writeInt(8);
            pairingPacket.getBuffer().writeInt(3);
            pairingPacket.getBuffer().writeInt(6);
            pairingPacket.getBuffer().writeBoolean(false);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(pairingPacket, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), new Object[0]);
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.PLAYER_KILLED_EVENT, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.0f", Float.valueOf(this.regenPercentage)));
        return list;
    }
}

