/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.common.AnimatorControlPacket;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class BasicAttack
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("a42e0198-fdbc-11eb-9a03-0242ac130003");
    public static final AnimationVariables.IndependentAnimationVariableKey<Boolean> COMBO = AnimationVariables.independent(animator -> false, false);
    private float dashAttackConsumption = 0.0f;
    private float airAttackConsumption = 0.0f;

    public static SkillBuilder<BasicAttack> createBasicAttackBuilder() {
        return ((SkillBuilder)((SkillBuilder)new SkillBuilder().setCategory(SkillCategories.BASIC_ATTACK)).setActivateType(Skill.ActivateType.ONE_SHOT)).setResource(Skill.Resource.NONE);
    }

    public static void setComboCounterWithEvent(ComboCounterHandleEvent.Causal reason, ServerPlayerPatch playerpatch, SkillContainer container, AnimationManager.AnimationAccessor<? extends StaticAnimation> causalAnimation, int value) {
        int prevValue = (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
        ComboCounterHandleEvent comboResetEvent = new ComboCounterHandleEvent(reason, playerpatch, causalAnimation, prevValue, value);
        container.getExecutor().getEventListener().triggerEvents(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, comboResetEvent);
        container.getDataManager().setData((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), comboResetEvent.getNextValue());
    }

    public BasicAttack(SkillBuilder<? extends BasicAttack> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (((StaticAnimation)event.getAnimation().get()).getProperty(AnimationProperty.ActionAnimationProperty.RESET_PLAYER_COMBO_COUNTER).orElse(true).booleanValue()) {
                CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
                List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> comboAnimations = itemCapability.getAutoAttackMotion(container.getExecutor());
                if (comboAnimations == null) {
                    return;
                }
                Set attackMotionSet = Set.copyOf(Sets.newHashSet(comboAnimations));
                if (!attackMotionSet.contains(event.getAnimation()) && itemCapability.shouldCancelCombo((LivingEntityPatch<?>)event.getPlayerPatch())) {
                    BasicAttack.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, (ServerPlayerPatch)event.getPlayerPatch(), container, event.getAnimation(), 0);
                }
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.dashAttackConsumption = parameters.m_128457_("dash_attack_consumption");
        this.airAttackConsumption = parameters.m_128457_("air_attack_consumption");
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executor) {
        EntityState playerState = executor.getEntityState();
        Player player = (Player)executor.getOriginal();
        return !player.m_5833_() && !executor.isInAir() && playerState.canBasicAttack();
    }

    @Override
    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        boolean airAttack;
        ServerPlayerPatch executor = skillContainer.getServerExecutor();
        SkillConsumeEvent event = new SkillConsumeEvent(executor, this, this.resource, null);
        executor.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, event);
        if (!event.isCanceled()) {
            event.getResourceType().consumer.consume(skillContainer, executor, event.getAmount());
        }
        if (executor.getEventListener().triggerEvents(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, new BasicAttackEvent(executor))) {
            return;
        }
        CapabilityItem cap = executor.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        AnimationManager.AnimationAccessor<? extends AttackAnimation> attackMotion = null;
        ServerPlayer player = (ServerPlayer)executor.getOriginal();
        SkillDataManager dataManager = skillContainer.getDataManager();
        int comboCounter = (Integer)dataManager.getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
        boolean dashAttack = player.m_20142_();
        boolean bl = airAttack = !((Player)skillContainer.getExecutor().getOriginal()).m_20096_() && !((Player)skillContainer.getExecutor().getOriginal()).m_20069_();
        if (player.m_20159_()) {
            PlayerRideableJumping rideable;
            Entity entity = player.m_20202_();
            if (entity instanceof PlayerRideableJumping && (rideable = (PlayerRideableJumping)entity).m_7132_() && cap.availableOnHorse() && cap.getMountAttackMotion() != null) {
                attackMotion = cap.getMountAttackMotion().get(comboCounter %= cap.getMountAttackMotion().size());
                ++comboCounter;
            }
        } else {
            List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> combo = cap.getAutoAttackMotion(executor);
            if (combo == null) {
                return;
            }
            int comboSize = combo.size();
            comboCounter = airAttack ? comboSize - 1 : (dashAttack ? comboSize - 2 : (comboCounter %= comboSize - 2));
            attackMotion = combo.get(comboCounter);
            comboCounter = dashAttack || airAttack ? 0 : comboCounter + 1;
        }
        BasicAttack.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, executor, skillContainer, attackMotion, comboCounter);
        if (attackMotion != null && this.checkConsumption(skillContainer, dashAttack, airAttack)) {
            ((Animator)executor.getAnimator()).getVariables().put(COMBO, attackMotion, true);
            ((Animator)executor.getAnimator()).playAnimation(attackMotion, 0.0f);
            boolean stiffAttack = EpicFightGameRules.STIFF_COMBO_ATTACKS.getRuleValue(((ServerPlayer)executor.getOriginal()).m_9236_());
            SPAnimatorControl animatorControlPacket = stiffAttack ? new SPAnimatorControl(AnimatorControlPacket.Action.PLAY, attackMotion, 0.0f, skillContainer.getExecutor()) : new SPAnimatorControl(AnimatorControlPacket.Action.PLAY_CLIENT, attackMotion, 0.0f, skillContainer.getExecutor(), AnimatorControlPacket.Layer.COMPOSITE_LAYER, AnimatorControlPacket.Priority.HIGHEST);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(animatorControlPacket, player, new Object[0]);
        }
        executor.updateEntityState();
    }

    @Override
    public void updateContainer(SkillContainer container) {
        if (!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > 16 && (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get()) > 0) {
            BasicAttack.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.TIME_EXPIRED, container.getServerExecutor(), container, null, 0);
        }
    }

    protected boolean checkConsumption(SkillContainer container, boolean dash, boolean air) {
        float finalConsumption;
        float f = finalConsumption = air ? this.airAttackConsumption : this.dashAttackConsumption;
        if (this.resource == Skill.Resource.STAMINA) {
            finalConsumption = container.getExecutor().getModifiedStaminaConsume(finalConsumption);
        }
        if (air || dash) {
            return container.getExecutor().consumeForSkill((Skill)this, this.resource, finalConsumption);
        }
        return container.getExecutor().consumeForSkill(this, this.resource);
    }
}

