/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat.controlify;

import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.client.input.InputMode;
import yesman.epicfight.api.client.input.PlayerInputState;
import yesman.epicfight.api.client.input.action.EpicFightInputAction;
import yesman.epicfight.api.client.input.action.MinecraftInputAction;
import yesman.epicfight.api.client.input.controller.ControllerBinding;
import yesman.epicfight.api.client.input.controller.IEpicFightControllerMod;
import yesman.epicfight.compat.controlify.ControlifyControllerBinding;
import yesman.epicfight.compat.controlify.EpicFightControlifyEntrypoint;

@ApiStatus.Internal
public class EpicFightControlifyControllerMod
implements IEpicFightControllerMod {
    @Override
    public String getModName() {
        return "Controlify";
    }

    @Override
    @NotNull
    public InputMode getInputMode() {
        return switch (EpicFightControlifyEntrypoint.getApi().currentInputMode()) {
            default -> throw new IncompatibleClassChangeError();
            case dev.isxander.controlify.InputMode.KEYBOARD_MOUSE -> InputMode.KEYBOARD_MOUSE;
            case dev.isxander.controlify.InputMode.CONTROLLER -> InputMode.CONTROLLER;
            case dev.isxander.controlify.InputMode.MIXED -> InputMode.MIXED;
        };
    }

    @NotNull
    public static ControllerBinding getBinding(@NotNull EpicFightInputAction action) {
        return new ControlifyControllerBinding(EpicFightControlifyEntrypoint.getControlifyBinding(action));
    }

    @NotNull
    public static ControllerBinding getBinding(@NotNull MinecraftInputAction action) {
        return new ControlifyControllerBinding(EpicFightControlifyEntrypoint.getControlifyBinding(action));
    }

    @Override
    @NotNull
    public PlayerInputState getInputState() {
        ControllerEntity controller = EpicFightControlifyEntrypoint.requireControllerEntity();
        InputBinding forwardBind = ControlifyBindings.WALK_FORWARD.on(controller);
        InputBinding backwardBind = ControlifyBindings.WALK_BACKWARD.on(controller);
        InputBinding leftBind = ControlifyBindings.WALK_LEFT.on(controller);
        InputBinding rightBind = ControlifyBindings.WALK_RIGHT.on(controller);
        InputBinding jumpBind = ControlifyBindings.JUMP.on(controller);
        InputBinding sneakBind = ControlifyBindings.SNEAK.on(controller);
        float forwardImpulse = forwardBind.analogueNow() - backwardBind.analogueNow();
        float leftImpulse = leftBind.analogueNow() - rightBind.analogueNow();
        return new PlayerInputState(leftImpulse, forwardImpulse, forwardBind.digitalNow(), backwardBind.digitalNow(), leftBind.digitalNow(), rightBind.digitalNow(), jumpBind.digitalNow(), sneakBind.digitalNow());
    }
}

