/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.common.collect.ImmutableList;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;

public class PowerKeyManager {
    private static final HashMap<ResourceLocation, String> KEY_CACHE = new HashMap();

    public static void clearCache() {
        KEY_CACHE.clear();
    }

    public static String getKeyIdentifier(ResourceLocation powerId) {
        if (KEY_CACHE.containsKey(powerId)) {
            return KEY_CACHE.get(powerId);
        }
        String key = PowerKeyManager.getKeyFromPower(powerId);
        KEY_CACHE.put(powerId, key);
        return key;
    }

    private static String getKeyFromPower(ResourceLocation powerId) {
        if (PowerTypeRegistry.contains((ResourceLocation)powerId)) {
            PowerType powerType = PowerTypeRegistry.get((ResourceLocation)powerId);
            Power power = powerType.create(null);
            String key = "";
            if (power instanceof Active) {
                key = ((Active)power).getKey().key;
            } else if (powerType instanceof MultiplePowerType) {
                ImmutableList subs = ((MultiplePowerType)powerType).getSubPowers();
                for (ResourceLocation sub : subs) {
                    String subKey = PowerKeyManager.getKeyFromPower(sub);
                    if (subKey.isEmpty()) continue;
                    return subKey;
                }
            }
            return key.equals("none") ? "key.origins.primary_active" : key;
        }
        return "";
    }
}

