/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen.tooltip;

import io.github.apace100.origins.Origins;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CraftingRecipeTooltipComponent
implements ClientTooltipComponent {
    private final int recipeWidth;
    private final NonNullList<ItemStack> inputs;
    private final ItemStack output;
    private static final ResourceLocation TEXTURE = Origins.identifier("textures/gui/tooltip/recipe_tooltip.png");

    public CraftingRecipeTooltipComponent(int recipeWidth, NonNullList<ItemStack> inputs, ItemStack output) {
        this.recipeWidth = recipeWidth;
        this.inputs = inputs;
        this.output = output;
    }

    public int m_142103_() {
        return 68;
    }

    public int m_142069_(Font textRenderer) {
        return 130;
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics context) {
        this.drawBackground(context, x, y);
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 3; ++row) {
                int index = column + row * this.recipeWidth;
                int slotX = x + 8 + column * 18;
                int slotY = y + 8 + row * 18;
                ItemStack stack = column >= this.recipeWidth ? ItemStack.f_41583_ : (ItemStack)this.inputs.get(index);
                context.m_280480_(stack, slotX, slotY);
                context.m_280370_(textRenderer, stack, slotX, slotY);
            }
        }
        context.m_280480_(this.output, x + 101, y + 25);
        context.m_280370_(textRenderer, this.output, x + 101, y + 25);
    }

    public void drawBackground(GuiGraphics context, int x, int y) {
        context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        context.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, 130, 86, 256, 256);
    }
}

