/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.screen.OriginDisplayScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ChooseOriginScreen
extends OriginDisplayScreen {
    private final ArrayList<OriginLayer> layerList;
    private int currentLayerIndex = 0;
    private int currentOrigin = 0;
    private final List<Origin> originSelection;
    private int maxSelection = 0;
    private Origin randomOrigin;

    public ChooseOriginScreen(ArrayList<OriginLayer> layerList, int currentLayerIndex, boolean showDirtBackground) {
        super((Component)Component.m_237115_((String)"origins.screen.choose_origin"), showDirtBackground);
        Origin newOrigin;
        this.layerList = layerList;
        this.currentLayerIndex = currentLayerIndex;
        this.originSelection = new ArrayList<Origin>(10);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        OriginLayer currentLayer = layerList.get(currentLayerIndex);
        List<ResourceLocation> originIdentifiers = currentLayer.getOrigins((Player)player);
        originIdentifiers.forEach(arg_0 -> this.lambda$new$0((Player)player, arg_0));
        this.originSelection.sort((a, b) -> {
            int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
            return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
        });
        this.maxSelection = this.originSelection.size();
        if (currentLayer.isRandomAllowed() && currentLayer.getRandomOrigins((Player)player).size() > 0) {
            ++this.maxSelection;
        }
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
        }
        this.showOrigin(newOrigin, layerList.get(currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()) == this.randomOrigin);
    }

    private void openNextLayerScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new WaitForNextLayerScreen(this.layerList, this.currentLayerIndex, this.showDirtBackground));
    }

    public boolean m_6913_() {
        return false;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.maxSelection > 1) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_130674_((String)"<"), b -> {
                Origin newOrigin;
                this.currentOrigin = (this.currentOrigin - 1 + this.maxSelection) % this.maxSelection;
                this.showOrigin(newOrigin, this.layerList.get(this.currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()) == this.randomOrigin);
            }).m_252987_(this.guiLeft - 40, this.f_96544_ / 2 - 10, 20, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_130674_((String)">"), b -> {
                Origin newOrigin;
                this.currentOrigin = (this.currentOrigin + 1) % this.maxSelection;
                this.showOrigin(newOrigin, this.layerList.get(this.currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()) == this.randomOrigin);
            }).m_252987_(this.guiLeft + 176 + 20, this.f_96544_ / 2 - 10, 20, 20).m_253136_());
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"origins.gui.select"), b -> {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            if (this.currentOrigin == this.originSelection.size()) {
                buf.m_130070_(this.layerList.get(this.currentLayerIndex).getIdentifier().toString());
                ClientPlayNetworking.send((ResourceLocation)ModPackets.CHOOSE_RANDOM_ORIGIN, (FriendlyByteBuf)buf);
            } else {
                buf.m_130070_(this.getCurrentOrigin().getIdentifier().toString());
                buf.m_130070_(this.layerList.get(this.currentLayerIndex).getIdentifier().toString());
                ClientPlayNetworking.send((ResourceLocation)ModPackets.CHOOSE_ORIGIN, (FriendlyByteBuf)buf);
            }
            this.openNextLayerScreen();
        }).m_252987_(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20).m_253136_());
    }

    @Override
    protected Component getTitleText() {
        if (this.getCurrentLayer().shouldOverrideChooseOriginTitle()) {
            return Component.m_237115_((String)this.getCurrentLayer().getTitleChooseOriginTranslationKey());
        }
        return Component.m_237110_((String)"origins.gui.choose_origin.title", (Object[])new Object[]{Component.m_237115_((String)this.getCurrentLayer().getTranslationKey())});
    }

    private Origin getCurrentOriginInternal() {
        if (this.currentOrigin == this.originSelection.size()) {
            if (this.randomOrigin == null) {
                this.initRandomOrigin();
            }
            return this.randomOrigin;
        }
        return this.originSelection.get(this.currentOrigin);
    }

    private void initRandomOrigin() {
        this.randomOrigin = new Origin(Origins.identifier("random"), new ItemStack((ItemLike)ModItems.ORB_OF_ORIGIN), Impact.NONE, -1, Integer.MAX_VALUE);
        MutableComponent randomOriginText = (MutableComponent)Component.m_130674_((String)"");
        List<ResourceLocation> randoms = this.layerList.get(this.currentLayerIndex).getRandomOrigins((Player)Minecraft.m_91087_().f_91074_);
        randoms.sort((ia, ib) -> {
            Origin a = OriginRegistry.get(ia);
            Origin b = OriginRegistry.get(ib);
            int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
            return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
        });
        for (ResourceLocation id : randoms) {
            randomOriginText.m_7220_((Component)OriginRegistry.get(id).getName());
            randomOriginText.m_7220_(Component.m_130674_((String)"\n"));
        }
        this.setRandomOriginText((Component)randomOriginText);
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
            return;
        }
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    private /* synthetic */ void lambda$new$0(Player player, ResourceLocation originId) {
        Origin origin = OriginRegistry.get(originId);
        if (origin.isChoosable()) {
            ItemStack displayItem = origin.getDisplayItem();
            if (!(displayItem.m_41720_() != Items.f_42680_ || displayItem.m_41782_() && displayItem.m_41783_().m_128441_("SkullOwner"))) {
                displayItem.m_41784_().m_128359_("SkullOwner", player.m_5446_().getString());
            }
            this.originSelection.add(origin);
        }
    }
}

