/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.registry;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.registry.ModEnchantments;
import io.github.apace100.origins.util.OriginLootCondition;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ModLoot {
    private static final ResourceLocation DUNGEON_LOOT = new ResourceLocation("minecraft", "chests/simple_dungeon");
    private static final ResourceLocation STRONGHOLD_LIBRARY = new ResourceLocation("minecraft", "chests/stronghold_library");
    private static final ResourceLocation MINESHAFT = new ResourceLocation("minecraft", "chests/abandoned_mineshaft");
    private static final ResourceLocation WATER_RUIN = new ResourceLocation("minecraft", "chests/underwater_ruin_small");
    public static final LootItemConditionType ORIGIN_LOOT_CONDITION = ModLoot.registerLootCondition("origin", new OriginLootCondition.Serializer());

    private static LootItemConditionType registerLootCondition(String path, Serializer<? extends LootItemCondition> serializer) {
        return (LootItemConditionType)Registry.m_122965_((Registry)BuiltInRegistries.f_256991_, (ResourceLocation)Origins.identifier(path), (Object)new LootItemConditionType(serializer));
    }

    public static void registerLootTables() {
        CompoundTag waterProtectionLevel1 = ModLoot.createEnchantmentTag(ModEnchantments.WATER_PROTECTION, 1);
        CompoundTag waterProtectionLevel2 = ModLoot.createEnchantmentTag(ModEnchantments.WATER_PROTECTION, 2);
        CompoundTag waterProtectionLevel3 = ModLoot.createEnchantmentTag(ModEnchantments.WATER_PROTECTION, 3);
        LootTableEvents.MODIFY.register((resourceManager, lootManager, identifier, tableBuilder, source) -> {
            if (!source.isBuiltin()) {
                return;
            }
            if (DUNGEON_LOOT.equals((Object)identifier)) {
                LootPool.Builder lootPool = new LootPool.Builder();
                lootPool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42690_).m_79707_(20).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)waterProtectionLevel1))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42690_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)waterProtectionLevel2))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(80));
                tableBuilder.m_79161_(lootPool);
            } else if (STRONGHOLD_LIBRARY.equals((Object)identifier)) {
                LootPool.Builder lootPool = new LootPool.Builder();
                lootPool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42690_).m_79707_(20).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)waterProtectionLevel2))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42690_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)waterProtectionLevel3))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(80));
                tableBuilder.m_79161_(lootPool);
            } else if (MINESHAFT.equals((Object)identifier)) {
                LootPool.Builder lootPool = new LootPool.Builder();
                lootPool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42690_).m_79707_(20).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)waterProtectionLevel1))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42690_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)waterProtectionLevel2))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(90));
                tableBuilder.m_79161_(lootPool);
            } else if (WATER_RUIN.equals((Object)identifier)) {
                LootPool.Builder lootPool = new LootPool.Builder();
                lootPool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42690_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)waterProtectionLevel1))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42690_).m_79707_(20).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)waterProtectionLevel2))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(110));
                tableBuilder.m_79161_(lootPool);
            }
        });
    }

    private static CompoundTag createEnchantmentTag(Enchantment enchantment, int level) {
        EnchantmentInstance entry = new EnchantmentInstance(enchantment, level);
        return EnchantedBookItem.m_41161_((EnchantmentInstance)entry).m_41783_();
    }
}

