/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class OriginUpgrade {
    private final ResourceLocation advancementCondition;
    private final ResourceLocation upgradeToOrigin;
    private final String announcement;

    public OriginUpgrade(ResourceLocation advancementCondition, ResourceLocation upgradeToOrigin, String announcement) {
        this.advancementCondition = advancementCondition;
        this.upgradeToOrigin = upgradeToOrigin;
        this.announcement = announcement;
    }

    public ResourceLocation getAdvancementCondition() {
        return this.advancementCondition;
    }

    public ResourceLocation getUpgradeToOrigin() {
        return this.upgradeToOrigin;
    }

    public String getAnnouncement() {
        return this.announcement;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.advancementCondition);
        buffer.m_130085_(this.upgradeToOrigin);
        buffer.m_130070_(this.announcement);
    }

    public static OriginUpgrade read(FriendlyByteBuf buffer) {
        ResourceLocation condition = buffer.m_130281_();
        ResourceLocation origin = buffer.m_130281_();
        String announcement = buffer.m_130136_(Short.MAX_VALUE);
        return new OriginUpgrade(condition, origin, announcement);
    }

    public static OriginUpgrade fromJson(JsonElement jsonElement) {
        JsonElement origin;
        JsonElement condition;
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException("Origin upgrade needs to be a JSON object.");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        if (json.has("condition") && (condition = json.get("condition")).isJsonPrimitive() && json.has("origin") && (origin = json.get("origin")).isJsonPrimitive()) {
            JsonElement anno;
            ResourceLocation conditionId = ResourceLocation.m_135820_((String)condition.getAsString());
            ResourceLocation originId = ResourceLocation.m_135820_((String)origin.getAsString());
            String announcement = "";
            if (json.has("announcement") && (anno = json.get("announcement")).isJsonPrimitive()) {
                announcement = anno.getAsString();
            }
            return new OriginUpgrade(conditionId, originId, announcement);
        }
        throw new JsonParseException("Origin upgrade JSON requires \"condition\" string and \"origin\" string.");
    }
}

