/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.MultiJsonDataLoader;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginRegistry;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class OriginManager
extends MultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public OriginManager() {
        super(GSON, "origins");
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> loader, ResourceManager manager, ProfilerFiller profiler) {
        OriginRegistry.reset();
        AtomicBoolean hasConfigChanged = new AtomicBoolean(false);
        loader.forEach((id, jel) -> {
            jel.forEach(je -> {
                try {
                    Origin origin = Origin.fromJson(id, je.getAsJsonObject());
                    if (!OriginRegistry.contains(id)) {
                        OriginRegistry.register(id, origin);
                    } else if (OriginRegistry.get(id).getLoadingPriority() < origin.getLoadingPriority()) {
                        OriginRegistry.update(id, origin);
                    }
                }
                catch (Exception e) {
                    Origins.LOGGER.error("There was a problem reading Origin file " + id.toString() + " (skipping): " + e.getMessage());
                }
            });
            if (OriginRegistry.contains(id)) {
                Origin origin = OriginRegistry.get(id);
                hasConfigChanged.set(hasConfigChanged.get() | Origins.config.addToConfig(origin));
                if (Origins.config.isOriginDisabled((ResourceLocation)id)) {
                    OriginRegistry.remove(id);
                } else {
                    LinkedList allPowers = new LinkedList();
                    origin.getPowerTypes().forEach(allPowers::add);
                    for (PowerType powerType : allPowers) {
                        if (!Origins.config.isPowerDisabled((ResourceLocation)id, powerType.getIdentifier())) continue;
                        origin.removePowerType(powerType);
                    }
                }
            }
        });
        Origins.LOGGER.info("Finished loading origins from data files. Registry contains " + OriginRegistry.size() + " origins.");
        if (hasConfigChanged.get()) {
            Origins.serializeConfig();
        }
    }

    public ResourceLocation getFabricId() {
        return new ResourceLocation("origins", "origins");
    }

    public Collection<ResourceLocation> getFabricDependencies() {
        return Set.of(Apoli.identifier((String)"powers"));
    }
}

