/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionTypes;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class OriginLayer
implements Comparable<OriginLayer> {
    private int order;
    private ResourceLocation identifier;
    private List<ConditionedOrigin> conditionedOrigins;
    private boolean enabled = false;
    private String nameTranslationKey;
    private String titleViewOriginTranslationKey;
    private String titleChooseOriginTranslationKey;
    private String missingOriginNameTranslationKey;
    private String missingOriginDescriptionTranslationKey;
    private boolean isRandomAllowed = false;
    private boolean doesRandomAllowUnchoosable = false;
    private List<ResourceLocation> originsExcludedFromRandom = null;
    private ResourceLocation defaultOrigin = null;
    private boolean autoChooseIfNoChoice = false;
    private boolean hidden = false;
    private boolean overrideViewOriginTitle = false;
    private boolean overrideChooseOriginTitle = false;

    public String getOrCreateTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "layer." + this.identifier.m_135827_() + "." + this.identifier.m_135815_() + ".name";
        }
        return this.nameTranslationKey;
    }

    public String getTranslationKey() {
        return this.getOrCreateTranslationKey();
    }

    public String getMissingOriginNameTranslationKey() {
        if (this.missingOriginNameTranslationKey == null || this.missingOriginNameTranslationKey.isEmpty()) {
            this.missingOriginNameTranslationKey = "layer." + this.identifier.m_135827_() + "." + this.identifier.m_135815_() + ".missing_origin.name";
        }
        return this.missingOriginNameTranslationKey;
    }

    public String getTitleViewOriginTranslationKey() {
        if (this.titleViewOriginTranslationKey == null || this.titleViewOriginTranslationKey.isEmpty()) {
            this.titleViewOriginTranslationKey = "layer." + this.identifier.m_135827_() + "." + this.identifier.m_135815_() + ".view_origin.name";
        }
        return this.titleViewOriginTranslationKey;
    }

    public boolean shouldOverrideViewOriginTitle() {
        return this.overrideViewOriginTitle;
    }

    public String getTitleChooseOriginTranslationKey() {
        if (this.titleChooseOriginTranslationKey == null || this.titleChooseOriginTranslationKey.isEmpty()) {
            this.titleChooseOriginTranslationKey = "layer." + this.identifier.m_135827_() + "." + this.identifier.m_135815_() + ".choose_origin.name";
        }
        return this.titleChooseOriginTranslationKey;
    }

    public boolean shouldOverrideChooseOriginTitle() {
        return this.overrideChooseOriginTitle;
    }

    public String getMissingOriginDescriptionTranslationKey() {
        if (this.missingOriginDescriptionTranslationKey == null || this.missingOriginDescriptionTranslationKey.isEmpty()) {
            this.missingOriginDescriptionTranslationKey = "layer." + this.identifier.m_135827_() + "." + this.identifier.m_135815_() + ".missing_origin.description";
        }
        return this.missingOriginDescriptionTranslationKey;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasDefaultOrigin() {
        return this.defaultOrigin != null;
    }

    public ResourceLocation getDefaultOrigin() {
        return this.defaultOrigin;
    }

    public boolean shouldAutoChoose() {
        return this.autoChooseIfNoChoice;
    }

    public List<ResourceLocation> getOrigins() {
        return this.conditionedOrigins.stream().flatMap(co -> co.getOrigins().stream()).filter(OriginRegistry::contains).collect(Collectors.toList());
    }

    public List<ResourceLocation> getOrigins(Player playerEntity) {
        return this.conditionedOrigins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.getOrigins().stream()).filter(OriginRegistry::contains).collect(Collectors.toList());
    }

    public int getOriginOptionCount(Player playerEntity) {
        long choosableOrigins = this.getOrigins(playerEntity).stream().map(OriginRegistry::get).filter(Origin::isChoosable).count();
        if (this.isRandomAllowed && this.getRandomOrigins(playerEntity).size() > 0) {
            ++choosableOrigins;
        }
        return (int)choosableOrigins;
    }

    public boolean contains(Origin origin) {
        return this.conditionedOrigins.stream().anyMatch(co -> co.getOrigins().stream().anyMatch(o -> o.equals((Object)origin.getIdentifier())));
    }

    public boolean contains(Origin origin, Player playerEntity) {
        return this.conditionedOrigins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).anyMatch(co -> co.getOrigins().stream().anyMatch(o -> o.equals((Object)origin.getIdentifier())));
    }

    public boolean isRandomAllowed() {
        return this.isRandomAllowed;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<ResourceLocation> getRandomOrigins(Player playerEntity) {
        return this.conditionedOrigins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.getOrigins().stream()).filter(OriginRegistry::contains).filter(o -> !this.originsExcludedFromRandom.contains(o)).filter(id -> this.doesRandomAllowUnchoosable || OriginRegistry.get(id).isChoosable()).collect(Collectors.toList());
    }

    public void merge(JsonObject json) {
        if (json.has("order")) {
            this.order = json.get("order").getAsInt();
        }
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        if (json.has("origins")) {
            JsonArray originArray = json.getAsJsonArray("origins");
            originArray.forEach(je -> this.conditionedOrigins.add(ConditionedOrigin.read(je)));
        }
        if (json.has("name")) {
            this.nameTranslationKey = GsonHelper.m_13851_((JsonObject)json, (String)"name", (String)"");
        }
        if (json.has("gui_title")) {
            JsonObject guiTitleObj = json.getAsJsonObject("gui_title");
            if (guiTitleObj.has("view_origin")) {
                this.titleViewOriginTranslationKey = GsonHelper.m_13851_((JsonObject)guiTitleObj, (String)"view_origin", (String)"");
                this.overrideViewOriginTitle = true;
            }
            if (guiTitleObj.has("choose_origin")) {
                this.titleChooseOriginTranslationKey = GsonHelper.m_13851_((JsonObject)guiTitleObj, (String)"choose_origin", (String)"");
                this.overrideChooseOriginTitle = true;
            }
        }
        if (json.has("missing_name")) {
            this.missingOriginNameTranslationKey = GsonHelper.m_13851_((JsonObject)json, (String)"missing_name", (String)"");
        }
        if (json.has("missing_description")) {
            this.missingOriginDescriptionTranslationKey = GsonHelper.m_13851_((JsonObject)json, (String)"missing_description", (String)"");
        }
        if (json.has("allow_random")) {
            this.isRandomAllowed = GsonHelper.m_13912_((JsonObject)json, (String)"allow_random");
        }
        if (json.has("allow_random_unchoosable")) {
            this.doesRandomAllowUnchoosable = GsonHelper.m_13912_((JsonObject)json, (String)"allow_random_unchoosable");
        }
        if (json.has("exclude_random") && json.get("exclude_random").isJsonArray()) {
            boolean replaceExclude = GsonHelper.m_13855_((JsonObject)json, (String)"replace_exclude_random", (boolean)false);
            if (replaceExclude) {
                this.originsExcludedFromRandom.clear();
            }
            JsonArray excludeRandomArray = json.getAsJsonArray("exclude_random");
            excludeRandomArray.forEach(je -> this.originsExcludedFromRandom.add(ResourceLocation.m_135820_((String)je.getAsString())));
        }
        if (json.has("default_origin")) {
            this.defaultOrigin = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"default_origin"));
        }
        if (json.has("auto_choose")) {
            this.autoChooseIfNoChoice = GsonHelper.m_13912_((JsonObject)json, (String)"auto_choose");
        }
        if (json.has("hidden")) {
            this.hidden = GsonHelper.m_13912_((JsonObject)json, (String)"hidden");
        }
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OriginLayer)) {
            return false;
        }
        return this.identifier.equals((Object)((OriginLayer)obj).identifier);
    }

    @Override
    public int compareTo(OriginLayer o) {
        return Integer.compare(this.order, o.order);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.identifier.toString());
        buffer.writeInt(this.order);
        buffer.writeBoolean(this.enabled);
        buffer.writeInt(this.conditionedOrigins.size());
        this.conditionedOrigins.forEach(co -> co.write(buffer));
        buffer.m_130070_(this.getOrCreateTranslationKey());
        buffer.m_130070_(this.getTitleViewOriginTranslationKey());
        buffer.m_130070_(this.getTitleChooseOriginTranslationKey());
        buffer.m_130070_(this.getMissingOriginNameTranslationKey());
        buffer.m_130070_(this.getMissingOriginDescriptionTranslationKey());
        buffer.writeBoolean(this.isRandomAllowed());
        if (this.isRandomAllowed()) {
            buffer.writeBoolean(this.doesRandomAllowUnchoosable);
            buffer.writeInt(this.originsExcludedFromRandom.size());
            this.originsExcludedFromRandom.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130085_(arg_0));
        }
        buffer.writeBoolean(this.hasDefaultOrigin());
        if (this.hasDefaultOrigin()) {
            buffer.m_130085_(this.defaultOrigin);
        }
        buffer.writeBoolean(this.autoChooseIfNoChoice);
        buffer.writeBoolean(this.hidden);
        buffer.writeBoolean(this.overrideViewOriginTitle);
        buffer.writeBoolean(this.overrideChooseOriginTitle);
    }

    @Environment(value=EnvType.CLIENT)
    public static OriginLayer read(FriendlyByteBuf buffer) {
        OriginLayer layer = new OriginLayer();
        layer.identifier = ResourceLocation.m_135820_((String)buffer.m_130277_());
        layer.order = buffer.readInt();
        layer.enabled = buffer.readBoolean();
        int conditionedOriginCount = buffer.readInt();
        layer.conditionedOrigins = new ArrayList<ConditionedOrigin>(conditionedOriginCount);
        for (int i = 0; i < conditionedOriginCount; ++i) {
            layer.conditionedOrigins.add(ConditionedOrigin.read(buffer));
        }
        layer.nameTranslationKey = buffer.m_130277_();
        layer.titleViewOriginTranslationKey = buffer.m_130277_();
        layer.titleChooseOriginTranslationKey = buffer.m_130277_();
        layer.missingOriginNameTranslationKey = buffer.m_130277_();
        layer.missingOriginDescriptionTranslationKey = buffer.m_130277_();
        layer.isRandomAllowed = buffer.readBoolean();
        if (layer.isRandomAllowed) {
            layer.doesRandomAllowUnchoosable = buffer.readBoolean();
            int excludedSize = buffer.readInt();
            layer.originsExcludedFromRandom = new LinkedList<ResourceLocation>();
            for (int i = 0; i < excludedSize; ++i) {
                layer.originsExcludedFromRandom.add(buffer.m_130281_());
            }
        }
        if (buffer.readBoolean()) {
            layer.defaultOrigin = buffer.m_130281_();
        }
        layer.autoChooseIfNoChoice = buffer.readBoolean();
        layer.hidden = buffer.readBoolean();
        layer.overrideViewOriginTitle = buffer.readBoolean();
        layer.overrideChooseOriginTitle = buffer.readBoolean();
        return layer;
    }

    public static OriginLayer fromJson(ResourceLocation id, JsonObject json) {
        int order = GsonHelper.m_13824_((JsonObject)json, (String)"order", (int)OriginLayers.size());
        if (!json.has("origins") || !json.get("origins").isJsonArray()) {
            throw new JsonParseException("Origin layer JSON requires \"origins\" array of origin IDs to include in the layer.");
        }
        JsonArray originArray = json.getAsJsonArray("origins");
        ArrayList<ConditionedOrigin> list = new ArrayList<ConditionedOrigin>(originArray.size());
        originArray.forEach(je -> list.add(ConditionedOrigin.read(je)));
        boolean enabled = GsonHelper.m_13855_((JsonObject)json, (String)"enabled", (boolean)true);
        OriginLayer layer = new OriginLayer();
        layer.order = order;
        layer.conditionedOrigins = list;
        layer.enabled = enabled;
        layer.identifier = id;
        layer.nameTranslationKey = GsonHelper.m_13851_((JsonObject)json, (String)"name", (String)"");
        if (json.has("gui_title") && json.get("gui_title").isJsonObject()) {
            JsonObject guiTitleObj = json.getAsJsonObject("gui_title");
            if (guiTitleObj.has("view_origin")) {
                layer.titleViewOriginTranslationKey = GsonHelper.m_13851_((JsonObject)guiTitleObj, (String)"view_origin", (String)"");
                layer.overrideViewOriginTitle = true;
            }
            if (guiTitleObj.has("choose_origin")) {
                layer.titleChooseOriginTranslationKey = GsonHelper.m_13851_((JsonObject)guiTitleObj, (String)"choose_origin", (String)"");
                layer.overrideChooseOriginTitle = true;
            }
        }
        layer.missingOriginNameTranslationKey = GsonHelper.m_13851_((JsonObject)json, (String)"missing_name", (String)"");
        layer.missingOriginDescriptionTranslationKey = GsonHelper.m_13851_((JsonObject)json, (String)"missing_description", (String)"");
        layer.isRandomAllowed = GsonHelper.m_13855_((JsonObject)json, (String)"allow_random", (boolean)false);
        layer.doesRandomAllowUnchoosable = GsonHelper.m_13855_((JsonObject)json, (String)"allow_random_unchoosable", (boolean)false);
        layer.originsExcludedFromRandom = new LinkedList<ResourceLocation>();
        if (json.has("exclude_random") && json.get("exclude_random").isJsonArray()) {
            JsonArray excludeRandomArray = json.getAsJsonArray("exclude_random");
            excludeRandomArray.forEach(je -> layer.originsExcludedFromRandom.add(ResourceLocation.m_135820_((String)je.getAsString())));
        }
        if (json.has("default_origin")) {
            layer.defaultOrigin = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"default_origin"));
        }
        layer.autoChooseIfNoChoice = GsonHelper.m_13855_((JsonObject)json, (String)"auto_choose", (boolean)false);
        layer.hidden = GsonHelper.m_13855_((JsonObject)json, (String)"hidden", (boolean)false);
        return layer;
    }

    public static class ConditionedOrigin {
        private final ConditionFactory.Instance condition;
        private final List<ResourceLocation> origins;
        private static final SerializableData conditionedOriginObjectData = new SerializableData().add("condition", ApoliDataTypes.ENTITY_CONDITION).add("origins", SerializableDataTypes.IDENTIFIERS);

        public ConditionedOrigin(ConditionFactory.Instance condition, List<ResourceLocation> origins) {
            this.condition = condition;
            this.origins = origins;
        }

        public boolean isConditionFulfilled(Player playerEntity) {
            return this.condition == null || this.condition.test((Object)playerEntity);
        }

        public List<ResourceLocation> getOrigins() {
            return this.origins;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.condition != null);
            if (this.condition != null) {
                this.condition.write(buffer);
            }
            buffer.writeInt(this.origins.size());
            this.origins.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130085_(arg_0));
        }

        @Environment(value=EnvType.CLIENT)
        public static ConditionedOrigin read(FriendlyByteBuf buffer) {
            ConditionFactory.Instance condition = null;
            if (buffer.readBoolean()) {
                condition = ConditionTypes.ENTITY.read(buffer);
            }
            int originCount = buffer.readInt();
            ArrayList<ResourceLocation> originList = new ArrayList<ResourceLocation>(originCount);
            for (int i = 0; i < originCount; ++i) {
                originList.add(buffer.m_130281_());
            }
            return new ConditionedOrigin(condition, originList);
        }

        public static ConditionedOrigin read(JsonElement element) {
            if (element.isJsonPrimitive()) {
                JsonPrimitive elemPrimitive = element.getAsJsonPrimitive();
                if (elemPrimitive.isString()) {
                    return new ConditionedOrigin(null, Lists.newArrayList((Object[])new ResourceLocation[]{ResourceLocation.m_135820_((String)elemPrimitive.getAsString())}));
                }
                throw new JsonParseException("Expected origin in layer to be either a string or an object.");
            }
            if (element.isJsonObject()) {
                SerializableData.Instance data = conditionedOriginObjectData.read(element.getAsJsonObject());
                return new ConditionedOrigin((ConditionFactory.Instance)data.get("condition"), (List)data.get("origins"));
            }
            throw new JsonParseException("Expected origin in layer to be either a string or an object.");
        }
    }
}

