/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ModPacketsS2C {
    @Environment(value=EnvType.CLIENT)
    public static void register() {
        ClientLoginNetworking.registerGlobalReceiver((ResourceLocation)ModPackets.HANDSHAKE, ModPacketsS2C::handleHandshake);
        ClientPlayConnectionEvents.INIT.register((clientPlayNetworkHandler, minecraftClient) -> {
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.OPEN_ORIGIN_SCREEN, ModPacketsS2C::openOriginScreen);
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.ORIGIN_LIST, ModPacketsS2C::receiveOriginList);
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.LAYER_LIST, ModPacketsS2C::receiveLayerList);
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.CONFIRM_ORIGIN, ModPacketsS2C::receiveOriginConfirmation);
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.BADGE_LIST, ModPacketsS2C::receiveBadgeList);
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveOriginConfirmation(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        OriginLayer layer = OriginLayers.getLayer(packetByteBuf.m_130281_());
        Origin origin = OriginRegistry.get(packetByteBuf.m_130281_());
        minecraftClient.execute(() -> {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)minecraftClient.f_91074_);
            component.setOrigin(layer, origin);
            if (minecraftClient.f_91080_ instanceof WaitForNextLayerScreen) {
                ((WaitForNextLayerScreen)minecraftClient.f_91080_).openSelection();
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static CompletableFuture<FriendlyByteBuf> handleHandshake(Minecraft minecraftClient, ClientHandshakePacketListenerImpl clientLoginNetworkHandler, FriendlyByteBuf packetByteBuf, Consumer<GenericFutureListener<? extends Future<? super Void>>> genericFutureListenerConsumer) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.writeInt(Origins.SEMVER.length);
        for (int i = 0; i < Origins.SEMVER.length; ++i) {
            buf.writeInt(Origins.SEMVER[i]);
        }
        OriginsClient.isServerRunningOrigins = true;
        return CompletableFuture.completedFuture(buf);
    }

    @Environment(value=EnvType.CLIENT)
    private static void openOriginScreen(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        boolean showDirtBackground = packetByteBuf.readBoolean();
        minecraftClient.execute(() -> {
            ArrayList<OriginLayer> layers = new ArrayList<OriginLayer>();
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)minecraftClient.f_91074_);
            OriginLayers.getLayers().forEach(layer -> {
                if (layer.isEnabled() && !component.hasOrigin((OriginLayer)layer)) {
                    layers.add((OriginLayer)layer);
                }
            });
            Collections.sort(layers);
            minecraftClient.m_91152_((Screen)new ChooseOriginScreen(layers, 0, showDirtBackground));
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveOriginList(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        try {
            ResourceLocation[] ids = new ResourceLocation[packetByteBuf.readInt()];
            SerializableData.Instance[] origins = new SerializableData.Instance[ids.length];
            for (int i = 0; i < origins.length; ++i) {
                ids[i] = ResourceLocation.m_135820_((String)packetByteBuf.m_130277_());
                origins[i] = Origin.DATA.read(packetByteBuf);
            }
            minecraftClient.execute(() -> {
                OriginsClient.isServerRunningOrigins = true;
                OriginRegistry.reset();
                for (int i = 0; i < ids.length; ++i) {
                    OriginRegistry.register(ids[i], Origin.createFromData(ids[i], origins[i]));
                }
            });
        }
        catch (Exception e) {
            Origins.LOGGER.error((Object)e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveLayerList(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        try {
            int layerCount = packetByteBuf.readInt();
            OriginLayer[] layers = new OriginLayer[layerCount];
            for (int i = 0; i < layerCount; ++i) {
                layers[i] = OriginLayer.read(packetByteBuf);
            }
            minecraftClient.execute(() -> {
                OriginLayers.clear();
                for (int i = 0; i < layerCount; ++i) {
                    OriginLayers.add(layers[i]);
                }
                ((OriginDataLoadedCallback)OriginDataLoadedCallback.EVENT.invoker()).onDataLoaded(true);
            });
        }
        catch (Exception e) {
            Origins.LOGGER.error((Object)e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveBadgeList(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        try {
            HashMap badges = new HashMap();
            int count = packetByteBuf.readInt();
            for (int i = 0; i < count; ++i) {
                ResourceLocation powerId = packetByteBuf.m_130281_();
                LinkedList<Badge> badgeList = new LinkedList<Badge>();
                int badgeCount = packetByteBuf.readInt();
                for (int j = 0; j < badgeCount; ++j) {
                    Badge badge = (Badge)BadgeManager.REGISTRY.receiveDataObject(packetByteBuf);
                    badgeList.add(badge);
                }
                badges.put(powerId, badgeList);
            }
            minecraftClient.execute(() -> {
                BadgeManager.clear();
                for (Map.Entry badgeEntry : badges.entrySet()) {
                    for (Badge badge : (List)badgeEntry.getValue()) {
                        BadgeManager.putPowerBadge((ResourceLocation)badgeEntry.getKey(), badge);
                    }
                }
            });
        }
        catch (Exception e) {
            Origins.LOGGER.error((Object)e);
        }
    }
}

