/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.apoli.mixin.EntityAccessor;
import io.github.apace100.origins.power.OriginsPowerTypes;
import io.github.apace100.origins.registry.ModDamageSources;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public final class WaterBreathingMixin {

    @Mixin(value={Player.class})
    public static abstract class UpdateAir
    extends LivingEntity {
        protected UpdateAir(EntityType<? extends LivingEntity> entityType, Level world) {
            super(entityType, world);
        }

        @Inject(at={@At(value="TAIL")}, method={"tick"})
        private void tick(CallbackInfo info) {
            if (OriginsPowerTypes.WATER_BREATHING.isActive((Entity)this)) {
                if (!(this.m_204029_(FluidTags.f_13131_) || this.m_21023_(MobEffects.f_19608_) || this.m_21023_(MobEffects.f_19592_))) {
                    if (!((EntityAccessor)this).callIsBeingRainedOn()) {
                        int landGain = this.m_7305_(0);
                        this.m_20301_(this.m_7302_(this.m_20146_()) - landGain);
                        if (this.m_20146_() == -20) {
                            this.m_20301_(0);
                            for (int i = 0; i < 8; ++i) {
                                double f = this.f_19796_.m_188500_() - this.f_19796_.m_188500_();
                                double g = this.f_19796_.m_188500_() - this.f_19796_.m_188500_();
                                double h = this.f_19796_.m_188500_() - this.f_19796_.m_188500_();
                                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20188_() + this.f_19796_.m_188583_() * 0.08, this.m_20262_(0.5), f * 0.5, g * 0.5 + 0.25, h * 0.5);
                            }
                            this.m_6469_(ModDamageSources.getSource(this.m_269291_(), ModDamageSources.NO_WATER_FOR_GILLS), 2.0f);
                        }
                    } else {
                        int landGain = this.m_7305_(0);
                        this.m_20301_(this.m_20146_() - landGain);
                    }
                } else if (this.m_20146_() < this.m_6062_()) {
                    this.m_20301_(this.m_7305_(this.m_20146_()));
                }
            }
        }

        @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isSubmergedIn(Lnet/minecraft/registry/tag/TagKey;)Z"), method={"updateTurtleHelmet"})
        public boolean isSubmergedInProxy(Player player, TagKey<Fluid> fluidTag) {
            boolean submerged = this.m_204029_(fluidTag);
            if (OriginsPowerTypes.WATER_BREATHING.isActive((Entity)this)) {
                return !submerged;
            }
            return submerged;
        }
    }

    @Mixin(value={LivingEntity.class})
    public static abstract class CanBreatheInWater
    extends Entity {
        public CanBreatheInWater(EntityType<?> type, Level world) {
            super(type, world);
        }

        @Inject(at={@At(value="HEAD")}, method={"canBreatheInWater"}, cancellable=true)
        public void doWaterBreathing(CallbackInfoReturnable<Boolean> info) {
            if (OriginsPowerTypes.WATER_BREATHING.isActive((Entity)this)) {
                info.setReturnValue((Object)true);
            }
        }
    }
}

