/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.command.LayerArgumentType;
import io.github.apace100.origins.command.OriginArgumentType;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class OriginCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"origin").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(Commands.m_82129_((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(OriginCommand::setOrigin)))))).then(Commands.m_82127_((String)"has").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(Commands.m_82129_((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(OriginCommand::hasOrigin)))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(OriginCommand::getOrigin))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"gui").executes(commandContext -> OriginCommand.openMultipleLayerScreens((CommandContext<CommandSourceStack>)commandContext, TargetType.INVOKER))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> OriginCommand.openMultipleLayerScreens((CommandContext<CommandSourceStack>)commandContext, TargetType.SPECIFY))).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(OriginCommand::openSingleLayerScreen))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"random").executes(commandContext -> OriginCommand.randomizeOrigins((CommandContext<CommandSourceStack>)commandContext, TargetType.INVOKER))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> OriginCommand.randomizeOrigins((CommandContext<CommandSourceStack>)commandContext, TargetType.SPECIFY))).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(OriginCommand::randomizeOrigin)))));
    }

    private static int setOrigin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(commandContext, (String)"targets");
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        Origin origin = OriginArgumentType.getOrigin(commandContext, "origin");
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        int processedTargets = 0;
        if (origin.equals(Origin.EMPTY) || originLayer.getOrigins().contains(origin.getIdentifier())) {
            for (ServerPlayer target : targets) {
                OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
                boolean hadOriginBefore = originComponent.hadOriginBefore();
                originComponent.setOrigin(originLayer, origin);
                originComponent.sync();
                OriginComponent.partialOnChosen((Player)target, hadOriginBefore, origin);
                ++processedTargets;
            }
            if (processedTargets == 1) {
                serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.set.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).m_5446_().getString(), Component.m_237115_((String)originLayer.getTranslationKey()), origin.getName()}), true);
            } else {
                int finalProcessedTargets = processedTargets;
                serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.set.success.multiple", (Object[])new Object[]{finalProcessedTargets, Component.m_237115_((String)originLayer.getTranslationKey()), origin.getName()}), true);
            }
        } else {
            serverCommandSource.m_81352_((Component)Component.m_237110_((String)"commands.origin.unregistered_in_layer", (Object[])new Object[]{origin.getIdentifier(), originLayer.getIdentifier()}));
        }
        return processedTargets;
    }

    private static int hasOrigin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(commandContext, (String)"targets");
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        Origin origin = OriginArgumentType.getOrigin(commandContext, "origin");
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        int processedTargets = 0;
        if (origin.equals(Origin.EMPTY) || originLayer.getOrigins().contains(origin.getIdentifier())) {
            for (ServerPlayer target : targets) {
                OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
                if (!origin.equals(Origin.EMPTY) && !originComponent.hasOrigin(originLayer) || !originComponent.getOrigin(originLayer).equals(origin)) continue;
                ++processedTargets;
            }
            if (processedTargets == 0) {
                serverCommandSource.m_81352_((Component)Component.m_237115_((String)"commands.execute.conditional.fail"));
            } else if (processedTargets == 1) {
                serverCommandSource.m_288197_(() -> Component.m_237115_((String)"commands.execute.conditional.pass"), true);
            } else {
                int finalProcessedTargets = processedTargets;
                serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.execute.conditional.pass_count", (Object[])new Object[]{finalProcessedTargets}), true);
            }
        } else {
            serverCommandSource.m_81352_((Component)Component.m_237110_((String)"commands.origin.unregistered_in_layer", (Object[])new Object[]{origin.getIdentifier(), originLayer.getIdentifier()}));
        }
        return processedTargets;
    }

    private static int getOrigin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(commandContext, (String)"target");
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        Origin origin = originComponent.getOrigin(originLayer);
        serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.get.result", (Object[])new Object[]{target.m_5446_().getString(), Component.m_237115_((String)originLayer.getTranslationKey()), origin.getName(), origin.getIdentifier()}), true);
        return 1;
    }

    private static int openSingleLayerScreen(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        Collection targets = EntityArgument.m_91477_(commandContext, (String)"targets");
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        for (ServerPlayer target : targets) {
            OriginCommand.openLayerScreen(target, originLayer);
        }
        serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.gui.layer", (Object[])new Object[]{targets.size(), Component.m_237115_((String)originLayer.getTranslationKey())}), true);
        return targets.size();
    }

    private static int openMultipleLayerScreens(CommandContext<CommandSourceStack> commandContext, TargetType targetType) throws CommandSyntaxException {
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        ArrayList<ServerPlayer> targets = new ArrayList<ServerPlayer>();
        List<OriginLayer> originLayers = OriginLayers.getLayers().stream().toList();
        switch (targetType.ordinal()) {
            case 0: {
                targets.add(serverCommandSource.m_81375_());
                break;
            }
            case 1: {
                targets.addAll(EntityArgument.m_91477_(commandContext, (String)"targets"));
            }
        }
        for (ServerPlayer target : targets) {
            for (OriginLayer originLayer : originLayers) {
                OriginCommand.openLayerScreen(target, originLayer);
            }
        }
        serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.gui.all", (Object[])new Object[]{targets.size()}), false);
        return targets.size();
    }

    private static int randomizeOrigin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        Collection targets = EntityArgument.m_91477_(commandContext, (String)"targets");
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        if (originLayer.isRandomAllowed()) {
            Origin origin = null;
            for (ServerPlayer target : targets) {
                origin = OriginCommand.getRandomOrigin(target, originLayer);
            }
            if (targets.size() > 1) {
                serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.random.success.multiple", (Object[])new Object[]{targets.size(), Component.m_237115_((String)originLayer.getTranslationKey())}), true);
            } else if (targets.size() == 1) {
                Origin finalOrigin = origin;
                serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.random.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).m_5446_().getString(), finalOrigin.getName(), Component.m_237115_((String)originLayer.getTranslationKey())}), false);
            }
            return targets.size();
        }
        serverCommandSource.m_81352_((Component)Component.m_237110_((String)"commands.origin.random.not_allowed", (Object[])new Object[]{Component.m_237115_((String)originLayer.getTranslationKey())}));
        return 0;
    }

    private static int randomizeOrigins(CommandContext<CommandSourceStack> commandContext, TargetType targetType) throws CommandSyntaxException {
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        ArrayList<ServerPlayer> targets = new ArrayList<ServerPlayer>();
        List<OriginLayer> originLayers = OriginLayers.getLayers().stream().filter(OriginLayer::isRandomAllowed).toList();
        switch (targetType.ordinal()) {
            case 0: {
                targets.add(serverCommandSource.m_81375_());
                break;
            }
            case 1: {
                targets.addAll(EntityArgument.m_91477_(commandContext, (String)"targets"));
            }
        }
        for (ServerPlayer target : targets) {
            for (OriginLayer originLayer : originLayers) {
                OriginCommand.getRandomOrigin(target, originLayer);
            }
        }
        serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.random.all", (Object[])new Object[]{targets.size(), originLayers.size()}), false);
        return targets.size();
    }

    private static void openLayerScreen(ServerPlayer target, OriginLayer originLayer) {
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
        if (originLayer.isEnabled()) {
            originComponent.setOrigin(originLayer, Origin.EMPTY);
        }
        originComponent.selectingOrigin(true);
        originComponent.checkAutoChoosingLayers((Player)target, false);
        originComponent.sync();
        if (originComponent.isSelectingOrigin()) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.writeBoolean(false);
            ServerPlayNetworking.send((ServerPlayer)target, (ResourceLocation)ModPackets.OPEN_ORIGIN_SCREEN, (FriendlyByteBuf)buffer);
        }
    }

    private static Origin getRandomOrigin(ServerPlayer target, OriginLayer originLayer) {
        List<Origin> origins = originLayer.getRandomOrigins((Player)target).stream().map(OriginRegistry::get).toList();
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
        Origin origin = origins.get(new Random().nextInt(origins.size()));
        boolean hadOriginBefore = originComponent.hadOriginBefore();
        boolean hadAllOrigins = originComponent.hasAllOrigins();
        originComponent.setOrigin(originLayer, origin);
        originComponent.checkAutoChoosingLayers((Player)target, false);
        originComponent.sync();
        if (originComponent.hasAllOrigins() && !hadAllOrigins) {
            OriginComponent.onChosen((Player)target, hadOriginBefore);
        }
        Origins.LOGGER.info("Player {} was randomly assigned the origin {} for layer {}", (Object)target.m_5446_().getString(), (Object)origin.getIdentifier().toString(), (Object)originLayer.getIdentifier().toString());
        return origin;
    }

    private static enum TargetType {
        INVOKER,
        SPECIFY;

    }
}

