/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactories;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.badge.TooltipBadge;
import io.github.apace100.origins.screen.tooltip.CraftingRecipeTooltipComponent;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.Nullable;

public record CraftingRecipeBadge(ResourceLocation spriteId, Recipe<TransientCraftingContainer> recipe, @Nullable Component prefix, @Nullable Component suffix) implements Badge
{
    public CraftingRecipeBadge(SerializableData.Instance instance) {
        this(instance.getId("sprite"), (Recipe<TransientCraftingContainer>)((Recipe)instance.get("recipe")), (Component)instance.get("prefix"), (Component)instance.get("suffix"));
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    public NonNullList<ItemStack> peekInputs(float time) {
        int seed = Mth.m_14143_((float)(time / 30.0f));
        NonNullList inputs = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        NonNullList ingredients = this.recipe.m_7527_();
        for (int index = 0; index < ingredients.size(); ++index) {
            ItemStack[] stacks = ((Ingredient)ingredients.get(index)).m_43908_();
            if (stacks.length <= 0) continue;
            inputs.set(index, (Object)stacks[seed % stacks.length]);
        }
        return inputs;
    }

    @Override
    public List<ClientTooltipComponent> getTooltipComponents(PowerType<?> powerType, int widthLimit, float time, Font textRenderer) {
        int recipeWidth;
        LinkedList<ClientTooltipComponent> tooltips = new LinkedList<ClientTooltipComponent>();
        if (Minecraft.m_91087_().f_91073_ == null) {
            Origins.LOGGER.warn("Could not construct crafting recipe badge, because world was null");
            return tooltips;
        }
        RegistryAccess dynamicRegistryManager = Minecraft.m_91087_().f_91073_.m_9598_();
        Recipe<TransientCraftingContainer> recipe = this.recipe;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            v0 = shapedRecipe.m_44220_();
        } else {
            v0 = recipeWidth = 3;
        }
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            MutableComponent recipeIdText = ((MutableComponent)Component.m_130674_((String)this.recipe.m_6423_().toString())).m_130940_(ChatFormatting.DARK_GRAY);
            widthLimit = Math.max(130, textRenderer.m_92852_((FormattedText)recipeIdText));
            if (this.prefix != null) {
                TooltipBadge.addLines(tooltips, this.prefix, textRenderer, widthLimit);
            }
            tooltips.add(new CraftingRecipeTooltipComponent(recipeWidth, this.peekInputs(time), this.recipe.m_8043_(dynamicRegistryManager)));
            if (this.suffix != null) {
                TooltipBadge.addLines(tooltips, this.suffix, textRenderer, widthLimit);
            }
            TooltipBadge.addLines(tooltips, (Component)recipeIdText, textRenderer, widthLimit);
        } else {
            widthLimit = 130;
            if (this.prefix != null) {
                TooltipBadge.addLines(tooltips, this.prefix, textRenderer, widthLimit);
            }
            tooltips.add(new CraftingRecipeTooltipComponent(recipeWidth, this.peekInputs(time), this.recipe.m_8043_(dynamicRegistryManager)));
            if (this.suffix != null) {
                TooltipBadge.addLines(tooltips, this.suffix, textRenderer, widthLimit);
            }
        }
        return tooltips;
    }

    @Override
    public SerializableData.Instance toData(SerializableData.Instance instance) {
        instance.set("sprite", (Object)this.spriteId);
        instance.set("recipe", this.recipe);
        instance.set("prefix", (Object)this.prefix);
        instance.set("suffix", (Object)this.suffix);
        return instance;
    }

    @Override
    public BadgeFactory getBadgeFactory() {
        return BadgeFactories.CRAFTING_RECIPE;
    }
}

