/*
 * Decompiled with CFR 0.152.
 */
package net.yonchi.refm.skill.weaponpassive;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.yonchi.refm.api.animation.JointTrack;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class WitherRapierPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("f068901b-b297-4194-9c94-970c8a7030e4");

    public WitherRapierPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            LivingEntity target = event.getTarget();
            if ((double)event.getAttackDamage() < 1.5) {
                return;
            }
            int duration = 33;
            int amplifier = target instanceof Player ? 0 : 2;
            MobEffectInstance witherEffect = new MobEffectInstance(MobEffects.f_19615_, duration, amplifier, false, false);
            target.m_7292_(witherEffect);
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            MobEffectInstance effect;
            LivingEntity player = (LivingEntity)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
            RandomSource random = RandomSource.m_216327_();
            if (player == null) {
                return;
            }
            if (!player.m_20069_() && !player.m_6047_() && !player.m_21255_() && player.m_20142_()) {
                int numParticles = 3;
                for (int i = 0; i < numParticles; ++i) {
                    float L = -0.1f;
                    float R = 0.1f;
                    double xOffset = (random.m_188500_() - 0.3) * 0.3;
                    double yOffset = (random.m_188500_() - random.m_188500_()) * 0.3;
                    double zOffset = (random.m_188500_() - 0.3) * 0.3;
                    Vec3 basePos = JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(0.0f, -1.0f, -0.3f), ((HumanoidArmature)Armatures.BIPED.get()).rootJoint);
                    ArrayList<Vec3> positions = new ArrayList<Vec3>();
                    positions.add(JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(L, 0.0f, 0.6f), ((HumanoidArmature)Armatures.BIPED.get()).head));
                    positions.add(JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(R, 0.0f, 0.6f), ((HumanoidArmature)Armatures.BIPED.get()).head));
                    positions.add(JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(L, 0.06f, 0.1f), ((HumanoidArmature)Armatures.BIPED.get()).chest));
                    positions.add(JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(R, 0.06f, 0.1f), ((HumanoidArmature)Armatures.BIPED.get()).chest));
                    positions.add(JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(0.0f, 0.6f, 0.0f), ((HumanoidArmature)Armatures.BIPED.get()).armL));
                    positions.add(JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(0.0f, 0.6f, 0.0f), ((HumanoidArmature)Armatures.BIPED.get()).armR));
                    positions.add(JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(0.0f, 0.2f, 0.2f), ((HumanoidArmature)Armatures.BIPED.get()).thighL));
                    positions.add(JointTrack.getJointWithTranslation(Minecraft.m_91087_().f_91074_, (Entity)player, new Vec3f(0.0f, 0.2f, 0.2f), ((HumanoidArmature)Armatures.BIPED.get()).thighR));
                    for (Vec3 pos : positions) {
                        if (pos == null) continue;
                        Vec3 ovalPos = pos.m_82520_(xOffset, yOffset, zOffset);
                        Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123762_, ovalPos.f_82479_, ovalPos.f_82480_, ovalPos.f_82481_, player.m_20184_().f_82479_, (double)0.052f, player.m_20184_().f_82481_);
                        if (particle == null) continue;
                        particle.m_107257_(6);
                    }
                    if (basePos == null) continue;
                    Particle particle1 = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123755_, basePos.f_82479_, basePos.f_82480_, basePos.f_82481_, player.m_20184_().f_82479_, (double)0.02f, player.m_20184_().f_82481_);
                    Particle particle2 = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123755_, basePos.f_82479_, basePos.f_82480_ + (double)0.26f, basePos.f_82481_, player.m_20184_().f_82479_, (double)0.012f, player.m_20184_().f_82481_);
                    if (particle1 != null) {
                        particle1.m_6569_(0.92f);
                        particle1.m_107257_(13);
                    }
                    if (particle2 == null) continue;
                    particle2.m_6569_(0.96f);
                    particle2.m_107257_(3);
                }
                MobEffectInstance slowfallEffect = new MobEffectInstance(MobEffects.f_19591_, 5, 0, true, false);
                player.m_7292_(slowfallEffect);
            } else if (player.m_21023_(MobEffects.f_19591_) && (effect = player.m_21124_(MobEffects.f_19591_)) != null && effect.m_19557_() < 10) {
                player.m_21195_(MobEffects.f_19591_);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        MobEffectInstance effect;
        super.onRemoved(container);
        LivingEntity player = (LivingEntity)container.getExecutor().getOriginal();
        if (player != null && player.m_21023_(MobEffects.f_19591_) && (effect = player.m_21124_(MobEffects.f_19591_)) != null && effect.m_19557_() < 10) {
            player.m_21195_(MobEffects.f_19591_);
        }
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }
}

