/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom.util;

import de.keksuccino.konkrete.config.Config;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractOptions {

    public static class UnsupportedOptionTypeException
    extends RuntimeException {
        public UnsupportedOptionTypeException() {
        }

        public UnsupportedOptionTypeException(String msg) {
            super(msg);
        }
    }

    public static class Option<T> {
        protected final Config config;
        protected final String key;
        protected final T defaultValue;
        protected final String category;

        public Option(@NotNull Config config, @NotNull String key, @NotNull T defaultValue, @NotNull String category) {
            this.config = Objects.requireNonNull(config);
            this.key = Objects.requireNonNull(key);
            this.defaultValue = Objects.requireNonNull(defaultValue);
            this.category = Objects.requireNonNull(category);
            this.register();
        }

        protected void register() {
            boolean unsupported = false;
            try {
                T t = this.defaultValue;
                if (t instanceof Integer) {
                    Integer i = (Integer)t;
                    this.config.registerValue(this.key, i, this.category);
                } else {
                    t = this.defaultValue;
                    if (t instanceof Double) {
                        Double d = (Double)t;
                        this.config.registerValue(this.key, d, this.category);
                    } else {
                        t = this.defaultValue;
                        if (t instanceof Long) {
                            Long l = (Long)t;
                            this.config.registerValue(this.key, l, this.category);
                        } else {
                            t = this.defaultValue;
                            if (t instanceof Float) {
                                Float f = (Float)t;
                                this.config.registerValue(this.key, f, this.category);
                            } else {
                                t = this.defaultValue;
                                if (t instanceof Boolean) {
                                    Boolean b = (Boolean)t;
                                    this.config.registerValue(this.key, b, this.category);
                                } else {
                                    t = this.defaultValue;
                                    if (t instanceof String) {
                                        String s = (String)t;
                                        this.config.registerValue(this.key, s, this.category);
                                    } else {
                                        unsupported = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (unsupported) {
                throw new UnsupportedOptionTypeException("Tried to register Option with unsupported type: " + this.key + " (" + this.defaultValue.getClass().getName() + ")");
            }
        }

        @NotNull
        public T getValue() {
            return (T)this.config.getOrDefault(this.key, this.defaultValue);
        }

        public Option<T> setValue(T value) {
            try {
                if (value == null) {
                    value = this.getDefaultValue();
                }
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    this.config.setValue(this.key, i);
                } else if (value instanceof Double) {
                    Double d = (Double)value;
                    this.config.setValue(this.key, d);
                } else if (value instanceof Long) {
                    Long l = (Long)value;
                    this.config.setValue(this.key, l);
                } else if (value instanceof Float) {
                    Float f = (Float)value;
                    this.config.setValue(this.key, f);
                } else if (value instanceof Boolean) {
                    Boolean b = (Boolean)value;
                    this.config.setValue(this.key, b);
                } else if (value instanceof String) {
                    String s = (String)value;
                    this.config.setValue(this.key, s);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return this;
        }

        public Option<T> resetToDefault() {
            this.setValue(null);
            return this;
        }

        @NotNull
        public T getDefaultValue() {
            return this.defaultValue;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }
    }
}

