/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom;

import de.keksuccino.justzoom.JustZoom;
import de.keksuccino.justzoom.KeyMappings;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ZoomHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static float zoomModifier = JustZoom.getOptions().baseZoomFactor.getValue().floatValue();
    public static double cachedNormalFov = 0.0;
    public static double cachedModifiedFov = 0.0;

    public static boolean isZooming() {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return false;
        }
        if (Minecraft.m_91087_().f_91066_.m_92176_().m_90613_() && !JustZoom.getOptions().allowZoomInMirroredView.getValue().booleanValue()) {
            return false;
        }
        return KeyMappings.KEY_TOGGLE_ZOOM.m_90857_();
    }

    public static boolean shouldZoomInOutSmooth() {
        return JustZoom.getOptions().smoothZoomInOut.getValue();
    }

    public static boolean shouldHideArmsWhenZooming() {
        return ZoomHandler.isZooming() && JustZoom.getOptions().hideArmsWhenZooming.getValue() != false;
    }

    public static float getFovModifier() {
        if ((double)zoomModifier > 1.0) {
            zoomModifier = 1.0f;
        }
        if ((double)zoomModifier <= 0.0) {
            zoomModifier = 1.0E-10f;
        }
        return zoomModifier;
    }

    public static void onMouseScroll(@NotNull MouseScrollFeedback feedback, double deltaX, double deltaY) {
        if (ZoomHandler.isZooming()) {
            feedback.cancel = true;
            if (deltaY < 0.0) {
                zoomModifier += JustZoom.getOptions().zoomOutPerScroll.getValue().floatValue();
            } else if (deltaY > 0.0) {
                zoomModifier -= JustZoom.getOptions().zoomInPerScroll.getValue().floatValue();
            }
        }
    }

    public static class MouseScrollFeedback {
        public boolean cancel = false;
    }
}

