/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.shapes.Shapes;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;

public interface BakingContext {
    public ShapeGenerator getShape(ResourceLocation var1);

    public static class Impl
    implements BakingContext {
        public final Map<ResourceLocation, ShapeGenerator> byId;
        private final ShapeGenerator fallbackShape;

        public Impl(Map<ResourceLocation, UnbakedShape> unbaked) {
            this.byId = Maps.newHashMapWithExpectedSize((int)unbaked.size());
            this.fallbackShape = ShapeGenerator.unit(Shapes.m_83144_());
        }

        @Override
        public ShapeGenerator getShape(ResourceLocation id) {
            return (ShapeGenerator)Preconditions.checkNotNull((Object)this.byId.get(id), (String)"Shape not found: %s", (Object)id);
        }

        public void bake(ResourceLocation id, UnbakedShape unbaked) {
            ShapeGenerator baked;
            try {
                baked = unbaked.bake(this);
            }
            catch (Exception e) {
                Kiwi.LOGGER.error("Failed to bake shape: %s".formatted(id), (Throwable)e);
                baked = this.fallbackShape;
            }
            this.byId.put(id, baked);
        }
    }
}

