/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FoxTailModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private PlayerModel<AbstractClientPlayer> playerModel;
    private ModelPart tail;
    private ModelPart ear1;
    private ModelPart ear2;

    public FoxTailModel(PlayerModel<AbstractClientPlayer> playerModel, LayerDefinition definition) {
        this.playerModel = playerModel;
        ModelPart root = definition.m_171564_();
        this.ear1 = root.m_171324_("right_ear");
        this.ear2 = root.m_171324_("left_ear");
        this.tail = root.m_171324_("tail");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        root.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(8, 1).m_171481_(-4.0f, -10.0f, -4.0f, 2.0f, 2.0f, 1.0f), PartPose.f_171404_);
        root.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(15, 1).m_171481_(2.0f, -10.0f, -4.0f, 2.0f, 2.0f, 1.0f), PartPose.f_171404_);
        root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171481_(0.0f, 0.0f, 0.0f, 4.0f, 9.0f, 5.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.ear1, (Object)this.ear2);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.tail);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.ear1.m_104315_(this.playerModel.f_102808_);
        this.ear2.m_104315_(this.playerModel.f_102808_);
        if (ageInTicks % 60.0f < 2.0f) {
            this.ear1.f_104204_ += 0.05f;
            this.ear2.f_104204_ -= 0.05f;
        }
        float delta = Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        if (entityIn.m_6047_()) {
            this.tail.m_104227_(-2.0f, 14.0f, 5.5f);
            this.tail.f_104203_ = 1.25f + delta;
        } else {
            this.tail.m_104227_(-2.0f, 10.0f, 0.5f);
            this.tail.f_104203_ = 0.85f + delta;
        }
    }
}

