/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.skyarena.block.custom;

import java.util.List;
import java.util.Map;
import net.jrdemiurge.skyarena.config.SkyArenaConfig;
import net.jrdemiurge.skyarena.config.TrophyConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Trophy
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public Trophy(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_) {
            String trophyKey = this.m_5456_().toString();
            TrophyConfig trophyConfig = SkyArenaConfig.configData.trophies.getOrDefault(trophyKey, SkyArenaConfig.DEFAULT_TROPHY);
            if (trophyConfig == null) {
                return InteractionResult.FAIL;
            }
            int cooldownTicks = trophyConfig.cooldown * 20;
            if (pPlayer.m_36335_().m_41519_(this.m_5456_())) {
                float cooldownPercent = pPlayer.m_36335_().m_41521_(this.m_5456_(), 0.0f);
                int remainingCooldownTicks = (int)(cooldownPercent * (float)cooldownTicks);
                int secondsLeft = remainingCooldownTicks / 20;
                pPlayer.m_5661_((Component)Component.m_237110_((String)"message.skyarena.cooldown_remaining", (Object[])new Object[]{secondsLeft}), true);
                return InteractionResult.FAIL;
            }
            pPlayer.m_36335_().m_41524_(this.m_5456_(), cooldownTicks);
            for (Map.Entry<String, TrophyConfig.EffectConfig> entry : trophyConfig.effects.entrySet()) {
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(entry.getKey()));
                if (effect == null) continue;
                TrophyConfig.EffectConfig effectConfig = entry.getValue();
                pPlayer.m_7292_(new MobEffectInstance(effect, effectConfig.duration * 20, effectConfig.amplifier, false, false));
            }
            pLevel.m_5594_(null, pPos, SoundEvents.f_144245_, SoundSource.PLAYERS, 5.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.skyarena.trophy"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            return true;
        }
        return false;
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false && fluid == Fluids.f_76193_;
    }
}

