/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.skyarena.block.custom;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.jrdemiurge.skyarena.SkyArena;
import net.jrdemiurge.skyarena.block.ModBlocks;
import net.jrdemiurge.skyarena.block.custom.AltarBlockTop;
import net.jrdemiurge.skyarena.block.entity.AltarBlockEntity;
import net.jrdemiurge.skyarena.block.entity.ModBlockEntity;
import net.jrdemiurge.skyarena.config.DifficultyLevelRange;
import net.jrdemiurge.skyarena.config.ExpandedMobInfo;
import net.jrdemiurge.skyarena.config.MobGroup;
import net.jrdemiurge.skyarena.config.PresetWave;
import net.jrdemiurge.skyarena.config.WaveMob;
import net.jrdemiurge.skyarena.item.ModItems;
import net.jrdemiurge.skyarena.triggers.DifficultyLevel1;
import net.jrdemiurge.skyarena.triggers.DifficultyLevel10;
import net.jrdemiurge.skyarena.triggers.DifficultyLevel100;
import net.jrdemiurge.skyarena.triggers.DifficultyLevel20;
import net.jrdemiurge.skyarena.triggers.DifficultyLevel5;
import net.jrdemiurge.skyarena.triggers.DifficultyLevel50;
import net.jrdemiurge.skyarena.triggers.UseAltarBattle;
import net.jrdemiurge.skyarena.triggers.UseMusicDisk;
import net.jrdemiurge.skyarena.triggers.UseNetheriteIngot;
import net.jrdemiurge.skyarena.triggers.UseStick;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AltarBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)16.0, (double)14.0);

    public AltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (!(blockEntity instanceof AltarBlockEntity)) {
                return InteractionResult.PASS;
            }
            AltarBlockEntity altarBlockEntity = (AltarBlockEntity)blockEntity;
            if (pPlayer.m_21120_(pHand).m_41720_() == Blocks.f_50752_.m_5456_()) {
                this.handleBedrockUse(pLevel, pPos, pPlayer, pHand, altarBlockEntity);
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21120_(pHand).m_41720_() == ModItems.MOB_ANALYZER.get()) {
                this.showArenaInfo(pPlayer, altarBlockEntity);
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21120_(pHand).m_41720_() == Items.f_42398_) {
                this.handleStickUse(pLevel, pPos, pPlayer, pHand, altarBlockEntity);
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21120_(pHand).m_41720_() instanceof RecordItem) {
                this.handleRecordUse(pLevel, pPos, pPlayer, pHand, altarBlockEntity);
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21120_(pHand).m_41720_() == Items.f_42418_) {
                return this.handleNetheriteIngotUse(pLevel, pPos, pPlayer, pHand, altarBlockEntity);
            }
            if (pLevel.m_46791_() == Difficulty.PEACEFUL) {
                MutableComponent message = Component.m_237115_((String)"message.skyarena.peaceful_disabled");
                pPlayer.m_5661_((Component)message, true);
                altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
                return InteractionResult.SUCCESS;
            }
            if (altarBlockEntity.isBattlePhaseActive() && altarBlockEntity.canSummonMobs()) {
                this.handleGiveReward(altarBlockEntity, pLevel, pPos, pState, pPlayer);
                return InteractionResult.SUCCESS;
            }
            if (!altarBlockEntity.isBattlePhaseActive()) {
                List<BlockPos> validPositions;
                int difficultyLevel = altarBlockEntity.getDifficultyLevel(pPlayer);
                if (!altarBlockEntity.isBattleOngoing(difficultyLevel)) {
                    this.handleMaxDifficultyLevel(pPlayer, altarBlockEntity);
                    return InteractionResult.SUCCESS;
                }
                if (pLevel.m_46467_() - altarBlockEntity.getBattleEndTime() < 30L) {
                    return InteractionResult.SUCCESS;
                }
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    UseAltarBattle.INSTANCE.trigger(serverPlayer);
                }
                if ((validPositions = altarBlockEntity.findValidSpawnPositions(pLevel, pPos, pPlayer)).isEmpty()) {
                    MutableComponent message = Component.m_237115_((String)"message.skyarena.no_spawn_position");
                    pPlayer.m_5661_((Component)message, true);
                    altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
                    return InteractionResult.SUCCESS;
                }
                altarBlockEntity.recordAltarActivation(pPlayer, pPos);
                altarBlockEntity.startMusic();
                if (!altarBlockEntity.isAutoWaveRun()) {
                    pLevel.m_5594_(null, pPos, SoundEvents.f_12563_, SoundSource.HOSTILE, 1.0f, 1.0f);
                } else {
                    pLevel.m_6269_(null, (Entity)pPlayer, SoundEvents.f_12563_, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                this.setEnvironment(pLevel, pPlayer, altarBlockEntity.isSetNight(), altarBlockEntity.isSetRain());
                altarBlockEntity.setGlowingCounter(0);
                altarBlockEntity.setBattleDifficultyLevel(difficultyLevel);
                MutableComponent message = Component.m_237115_((String)"message.skyarena.difficult_level").m_7220_((Component)Component.m_237113_((String)String.valueOf(difficultyLevel)));
                pPlayer.m_5661_((Component)message, true);
                altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
                String teamName = !altarBlockEntity.isDisableMobItemDrop() ? "summonedByArena" : "summonedByArenaWithoutLoot";
                PlayerTeam summonedMobsTeam = pLevel.m_6188_().m_83489_(teamName);
                if (summonedMobsTeam == null) {
                    summonedMobsTeam = pLevel.m_6188_().m_83492_(teamName);
                    summonedMobsTeam.m_83355_(false);
                    summonedMobsTeam.m_83344_(Team.CollisionRule.NEVER);
                }
                double statMultiplier = altarBlockEntity.getStatMultiplier(pPlayer);
                double statCoefPerBlocks = altarBlockEntity.getStatMultiplierCoefficientPerBlocks();
                Map<Integer, PresetWave> presetWaves = altarBlockEntity.getPresetWaves();
                if (presetWaves.containsKey(difficultyLevel) && presetWaves.get((Object)Integer.valueOf((int)difficultyLevel)).mobStatMultiplier != 0.0) {
                    statMultiplier = presetWaves.get((Object)Integer.valueOf((int)difficultyLevel)).mobStatMultiplier;
                }
                if (statCoefPerBlocks != 0.0) {
                    double distance = Math.sqrt(pPos.m_123331_((Vec3i)BlockPos.f_121853_));
                    double thousands = Math.floor(distance / 1000.0);
                    statMultiplier *= 1.0 + statCoefPerBlocks * thousands;
                }
                if (presetWaves.containsKey(difficultyLevel) && presetWaves.get((Object)Integer.valueOf((int)difficultyLevel)).mobs != null) {
                    PresetWave wave = presetWaves.get(difficultyLevel);
                    for (WaveMob waveMob : wave.mobs) {
                        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(waveMob.type));
                        if (entityType == null) continue;
                        for (int i = 0; i < waveMob.count; ++i) {
                            AltarBlock.spawnArenaMob(pLevel, altarBlockEntity, entityType, validPositions, statMultiplier, waveMob.type, summonedMobsTeam);
                        }
                    }
                    if (!altarBlockEntity.canSummonMobs()) {
                        altarBlockEntity.setBattlePhaseActive(true);
                    }
                    return InteractionResult.SUCCESS;
                }
                int remainingPoints = altarBlockEntity.getPoints(pPlayer);
                double pointsCoefPerBlocks = altarBlockEntity.getPointsCoefficientPerBlocks();
                if (pointsCoefPerBlocks != 0.0) {
                    double distance = Math.sqrt(pPos.m_123331_((Vec3i)BlockPos.f_121853_));
                    double thousands = Math.floor(distance / 1000.0);
                    remainingPoints = (int)((double)remainingPoints * (1.0 + pointsCoefPerBlocks * thousands));
                }
                int mobCostRatio = altarBlockEntity.getMobCostRatio();
                List<ExpandedMobInfo> availableMobs = altarBlockEntity.getAvailableMobs(altarBlockEntity.getBattleDifficultyLevel());
                if (availableMobs.isEmpty()) {
                    MutableComponent message_2 = Component.m_237115_((String)"message.skyarena.available_mobs_is_empty");
                    pPlayer.m_5661_((Component)message_2, true);
                    altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
                    return InteractionResult.SUCCESS;
                }
                int minMobValue = availableMobs.stream().mapToInt(mob -> mob.cost).min().orElse(Integer.MAX_VALUE);
                int skipCount = 0;
                while (remainingPoints >= minMobValue) {
                    EntityType entityType;
                    ExpandedMobInfo mobInfo = availableMobs.get(ThreadLocalRandom.current().nextInt(availableMobs.size()));
                    if (mobInfo.mobSpawnChance < 1.0 && ThreadLocalRandom.current().nextDouble() > mobInfo.mobSpawnChance) continue;
                    int mobValue = mobInfo.cost;
                    if (mobValue < remainingPoints / mobCostRatio && skipCount < 6) {
                        ++skipCount;
                        continue;
                    }
                    skipCount = 0;
                    if (remainingPoints < mobValue || (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(mobInfo.mobId))) == null) continue;
                    boolean spawnSquad = ThreadLocalRandom.current().nextDouble() < mobInfo.squadSpawnChance;
                    int mobsToSpawn = spawnSquad ? mobInfo.squadSpawnSize : 1;
                    double actualMultiplier = statMultiplier * mobInfo.statMultiplierCoefficient;
                    for (int i = 0; i < mobsToSpawn && remainingPoints >= mobValue; ++i) {
                        boolean success = AltarBlock.spawnArenaMob(pLevel, altarBlockEntity, entityType, validPositions, actualMultiplier, mobInfo.mobId, summonedMobsTeam);
                        if (!success) continue;
                        remainingPoints -= mobValue;
                    }
                }
                if (!altarBlockEntity.canSummonMobs()) {
                    altarBlockEntity.setBattlePhaseActive(true);
                }
                return InteractionResult.SUCCESS;
            }
            altarBlockEntity.applyGlowEffectToSummonedMobs(pPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean spawnArenaMob(Level pLevel, AltarBlockEntity altarBlockEntity, EntityType<?> entityType, List<BlockPos> validPositions, double statMultiplier, String mobTypeString, PlayerTeam summonedMobsTeam) {
        Entity mob = entityType.m_20615_(pLevel);
        if (mob == null) {
            return false;
        }
        BlockPos spawnPos = validPositions.get(ThreadLocalRandom.current().nextInt(validPositions.size()));
        mob.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
        if (mob instanceof Mob) {
            AttributeInstance attackAttribute;
            Mob mobEntity = (Mob)mob;
            if (altarBlockEntity.isDisableMobItemDrop()) {
                CompoundTag entityData = mobEntity.m_20240_(new CompoundTag());
                entityData.m_128359_("DeathLootTable", "minecraft:empty");
                mobEntity.m_20258_(entityData);
            }
            mobEntity.m_21530_();
            AttributeInstance healthAttribute = mobEntity.m_21051_(Attributes.f_22276_);
            if (healthAttribute != null) {
                double baseHealth = healthAttribute.m_22115_();
                healthAttribute.m_22100_(baseHealth * statMultiplier);
                mobEntity.m_21153_(mobEntity.m_21233_());
            }
            if ((attackAttribute = mobEntity.m_21051_(Attributes.f_22281_)) != null) {
                double baseDamage = attackAttribute.m_22115_();
                attackAttribute.m_22100_(baseDamage * statMultiplier);
            }
            MobSpawnType spawnType = MobSpawnType.NATURAL;
            if (mobTypeString.equals("cataclysm:scylla") || mobTypeString.equals("cataclysm:netherite_monstrosity")) {
                spawnType = MobSpawnType.COMMAND;
            }
            mobEntity.m_6518_((ServerLevelAccessor)((ServerLevel)pLevel), pLevel.m_6436_(mobEntity.m_20183_()), spawnType, null, null);
            if (!mobTypeString.equals("born_in_chaos_v1:spiritof_chaos")) {
                pLevel.m_6188_().m_6546_(mob.m_20149_(), summonedMobsTeam);
            }
        }
        pLevel.m_7967_(mob);
        altarBlockEntity.addSummonedMob(mob);
        return true;
    }

    public void showArenaInfo(Player pPlayer, AltarBlockEntity altarBlockEntity) {
        int n;
        Map<Integer, PresetWave> presetWaves;
        LinkedHashMap<String, MobGroup> mobGroups;
        String[] lines;
        MutableComponent message = Component.m_237113_((String)"\u00a74=== Arena Info ===\n");
        StringBuilder logMessage = new StringBuilder("=== Arena Info ===\n");
        int points = altarBlockEntity.getPoints(pPlayer);
        double pointsCoefPerBlocks = altarBlockEntity.getPointsCoefficientPerBlocks();
        if (pointsCoefPerBlocks != 0.0) {
            BlockPos pPos = altarBlockEntity.m_58899_();
            double distance = Math.sqrt(pPos.m_123331_((Vec3i)BlockPos.f_121853_));
            double thousands = Math.floor(distance / 1000.0);
            points = (int)((double)points * (1.0 + pointsCoefPerBlocks * thousands));
        }
        double statMultiplier = altarBlockEntity.getStatMultiplier(pPlayer);
        double statCoefPerBlocks = altarBlockEntity.getStatMultiplierCoefficientPerBlocks();
        if (statCoefPerBlocks != 0.0) {
            BlockPos pPos = altarBlockEntity.m_58899_();
            double distance = Math.sqrt(pPos.m_123331_((Vec3i)BlockPos.f_121853_));
            double thousands = Math.floor(distance / 1000.0);
            statMultiplier *= 1.0 + statCoefPerBlocks * thousands;
        }
        for (String string : lines = new String[]{"Arena Type: " + altarBlockEntity.getArenaType(), "Difficulty Level: " + altarBlockEntity.getDifficultyLevel(pPlayer), "Points: " + points, "Stat Multiplier: " + statMultiplier, "Starting Points: " + altarBlockEntity.getStartingPoints(), "Starting Stat Multiplier: " + altarBlockEntity.getStartingStatMultiplier(), "Mob Spawn Radius: " + altarBlockEntity.getMobSpawnRadius(), "Spawn Distance From Player: " + altarBlockEntity.getSpawnDistanceFromPlayer(), "Battle Loss Distance: " + altarBlockEntity.getBattleLossDistance(), "Mob Teleport Distance: " + altarBlockEntity.getMobTeleportDistance(), "Mob Griefing Protection Radius: " + altarBlockEntity.getMobGriefingProtectionRadius(), "Full Protection Radius: " + altarBlockEntity.getFullProtectionRadius(), "Boss Bar Hide Radius: " + altarBlockEntity.getBossBarHideRadius(), "Mob Cost Ratio: " + altarBlockEntity.getMobCostRatio(), "Allow Difficulty Reset: " + altarBlockEntity.isAllowDifficultyReset(), "Allow Water And Air Spawn: " + altarBlockEntity.isAllowWaterAndAirSpawn(), "Individual Player Stats: " + altarBlockEntity.isIndividualPlayerStats(), "Set Night: " + altarBlockEntity.isSetNight(), "Set Rain: " + altarBlockEntity.isSetRain(), "Disable Mob Item Drop: " + altarBlockEntity.isDisableMobItemDrop(), "Reset Difficulty On Defeat: " + altarBlockEntity.isResetDifficultyOnDefeat(), "Auto Wave Run: " + altarBlockEntity.isAutoWaveRun(), "Points Coefficient Per 1000 Blocks: " + altarBlockEntity.getPointsCoefficientPerBlocks(), "Stat Multiplier Coefficient Per 1000 Blocks: " + altarBlockEntity.getStatMultiplierCoefficientPerBlocks(), "Loot Table Count Coefficient Per 1000 Blocks: " + altarBlockEntity.getLootTableCountCoefficientPerBlocks()}) {
            message = message.m_7220_((Component)Component.m_237113_((String)("\u00a76" + string.split(":")[0] + ": \u00a7a" + string.split(": ")[1] + "\n")));
            logMessage.append(string).append("\n");
        }
        List<DifficultyLevelRange> ranges = altarBlockEntity.getDifficultyLevelRanges();
        if (!ranges.isEmpty()) {
            message = message.m_7220_((Component)Component.m_237113_((String)"\u00a74=== Difficulty Ranges ===\n"));
            logMessage.append("=== Difficulty Ranges ===\n");
            for (DifficultyLevelRange range : ranges) {
                String string = String.valueOf(range.range.get(0)) + "\u2013" + String.valueOf(range.range.get(1));
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a76Range: \u00a7a" + string + "\n")));
                logMessage.append("Range: ").append(string).append("\n");
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Points Increase: \u00a7a" + range.pointsIncrease + "\n")));
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Stat Multiplier Increase: \u00a7a" + range.statMultiplierIncrease + "\n")));
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Reward Loot Table: \u00a7a" + range.rewardLootTable + "\n")));
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Reward Count: \u00a7a" + range.rewardCount + "\n")));
                logMessage.append("  Points Increase: ").append(range.pointsIncrease).append("\n");
                logMessage.append("  Stat Multiplier Increase: ").append(range.statMultiplierIncrease).append("\n");
                logMessage.append("  Reward Loot Table: ").append(range.rewardLootTable).append("\n");
                logMessage.append("  Reward Count: ").append(range.rewardCount).append("\n");
                if (range.mobGroupsUsed.isEmpty()) continue;
                String string2 = String.join((CharSequence)", ", range.mobGroupsUsed);
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Mob Groups: \u00a7e" + string2 + "\n")));
                logMessage.append("  Mob Groups: ").append(string2).append("\n");
            }
        }
        if (!(mobGroups = altarBlockEntity.getMobGroups()).isEmpty()) {
            message = message.m_7220_((Component)Component.m_237113_((String)"\u00a74=== Mob Groups ===\n"));
            logMessage.append("=== Mob Groups ===\n");
            for (Map.Entry entry : mobGroups.entrySet()) {
                String string = (String)entry.getKey();
                MobGroup group = (MobGroup)entry.getValue();
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a76Group: \u00a7a" + string + "\n")));
                logMessage.append("Group: ").append(string).append("\n");
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Squad Chance: \u00a7a" + group.squadSpawnChance + "\n")));
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Squad Size: \u00a7a" + group.squadSpawnSize + "\n")));
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Stat Multiplier Coefficient: \u00a7a" + group.statMultiplierCoefficient + "\n")));
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Mob Spawn Chance: \u00a7a" + group.mobSpawnChance + "\n")));
                message = message.m_7220_((Component)Component.m_237113_((String)"\u00a77  Mobs: \u00a78[list printed to console]\n"));
                logMessage.append("  Squad Chance: ").append(group.squadSpawnChance).append("\n");
                logMessage.append("  Squad Size: ").append(group.squadSpawnSize).append("\n");
                logMessage.append("  Stat Multiplier Coefficient: ").append(group.statMultiplierCoefficient).append("\n");
                logMessage.append("  Mob Spawn Chance: ").append(group.mobSpawnChance).append("\n");
                for (Map.Entry<String, Integer> mobEntry : group.mobValues.entrySet()) {
                    String mobId = mobEntry.getKey();
                    Integer mobValue = mobEntry.getValue();
                    logMessage.append("    - ").append(mobId).append(": ").append(mobValue).append("\n");
                }
            }
        }
        if ((presetWaves = altarBlockEntity.getPresetWaves()) != null && !presetWaves.isEmpty()) {
            message = message.m_7220_((Component)Component.m_237113_((String)"\u00a74=== Preset Waves ===\n"));
            logMessage.append("=== Preset Waves ===\n");
            for (Map.Entry<Integer, PresetWave> entry : presetWaves.entrySet()) {
                int waveNumber = entry.getKey();
                PresetWave wave = entry.getValue();
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a76Wave " + waveNumber + ":\n")));
                logMessage.append("Wave ").append(waveNumber).append(":\n");
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Stat Multiplier: \u00a7a" + wave.mobStatMultiplier + "\n")));
                logMessage.append("  Stat Multiplier: ").append(wave.mobStatMultiplier).append("\n");
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Reward Loot Table: \u00a7a" + wave.rewardLootTable + "\n")));
                logMessage.append("  Reward Loot Table: ").append(wave.rewardLootTable).append("\n");
                message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77  Reward Count: \u00a7a" + wave.rewardCount + "\n")));
                logMessage.append("  Reward Count: ").append(wave.rewardCount).append("\n");
                for (WaveMob mob : wave.mobs) {
                    message = message.m_7220_((Component)Component.m_237113_((String)("\u00a77    - \u00a76" + mob.type + "\u00a77 x\u00a7a" + mob.count + "\n")));
                    logMessage.append("    - ").append(mob.type).append(" x").append(mob.count).append("\n");
                }
            }
        }
        if ((n = message.getString().split("\n").length) > 90) {
            message = message.m_7220_((Component)Component.m_237113_((String)"\u00a7cToo much info! Check console for full details."));
        }
        pPlayer.m_5661_((Component)message, false);
        SkyArena.LOGGER.info(logMessage.toString());
    }

    private void handleBedrockUse(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, AltarBlockEntity altarBlockEntity) {
        if (altarBlockEntity.isBattlePhaseActive()) {
            MutableComponent message = Component.m_237115_((String)"message.skyarena.cannot_do_during_battle");
            pPlayer.m_5661_((Component)message, true);
            altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
            return;
        }
        altarBlockEntity.switchToNextArena();
        MutableComponent message = Component.m_237113_((String)altarBlockEntity.getArenaType());
        pPlayer.m_5661_((Component)message, true);
        altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
        pLevel.m_5594_(null, pPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void handleStickUse(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, AltarBlockEntity altarBlockEntity) {
        altarBlockEntity.clearRecordItem();
        altarBlockEntity.stopMusic();
        pLevel.m_5594_(null, pPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            UseStick.INSTANCE.trigger(serverPlayer);
        }
    }

    private void handleRecordUse(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, AltarBlockEntity altarBlockEntity) {
        altarBlockEntity.setRecordItem(pPlayer.m_21120_(pHand));
        pLevel.m_5594_(null, pPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (altarBlockEntity.isBattlePhaseActive()) {
            altarBlockEntity.stopMusic();
            altarBlockEntity.startMusic();
        }
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            UseMusicDisk.INSTANCE.trigger(serverPlayer);
        }
    }

    private InteractionResult handleNetheriteIngotUse(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, AltarBlockEntity altarBlockEntity) {
        if (!altarBlockEntity.isAllowDifficultyReset()) {
            MutableComponent message = Component.m_237115_((String)"message.skyarena.cannot_reset_difficulty");
            pPlayer.m_5661_((Component)message, true);
            altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
            return InteractionResult.PASS;
        }
        if (altarBlockEntity.isBattlePhaseActive()) {
            MutableComponent message = Component.m_237115_((String)"message.skyarena.cannot_do_during_battle");
            pPlayer.m_5661_((Component)message, true);
            altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
            return InteractionResult.PASS;
        }
        if (pPlayer.m_36335_().m_41519_(Items.f_42418_)) {
            return InteractionResult.PASS;
        }
        altarBlockEntity.setDifficultyLevel(pPlayer, 1);
        pPlayer.m_21120_(pHand).m_41774_(1);
        pPlayer.m_36335_().m_41524_(Items.f_42418_, 40);
        pLevel.m_5594_(null, pPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
        MutableComponent message = Component.m_237115_((String)"message.skyarena.points_reset");
        pPlayer.m_5661_((Component)message, true);
        altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            UseNetheriteIngot.INSTANCE.trigger(serverPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    private void handleMaxDifficultyLevel(Player pPlayer, AltarBlockEntity altarBlockEntity) {
        MutableComponent message = ThreadLocalRandom.current().nextBoolean() ? Component.m_237115_((String)"message.skyarena.max_difficult_level_1") : Component.m_237115_((String)"message.skyarena.max_difficult_level_2");
        pPlayer.m_5661_((Component)message, true);
        altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
    }

    private void handleGiveReward(AltarBlockEntity altarBlockEntity, Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        double lootCountCoefPerBlocks;
        if (!altarBlockEntity.isAutoWaveRun()) {
            altarBlockEntity.removeAltarActivationForPlayer();
        }
        this.handleVictoryTriggers(altarBlockEntity, pPlayer);
        if (altarBlockEntity.isBattleOngoing(altarBlockEntity.getDifficultyLevel(pPlayer) + 1)) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"message.skyarena.victory"), true);
            altarBlockEntity.putPlayerMessageTimestamps(pPlayer);
        } else if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            MutableComponent title = Component.m_237115_((String)"message.skyarena.victory");
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)title));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 80, 10));
        }
        int difficultyLevel = altarBlockEntity.getBattleDifficultyLevel();
        if (difficultyLevel == 50) {
            this.sendDiscordInvite(pPlayer);
        }
        int keyCount = 1;
        String rewardLootTableId = "minecraft:empty";
        Map<Integer, PresetWave> presetWaves = altarBlockEntity.getPresetWaves();
        AltarBlockEntity.LootReward reward = altarBlockEntity.getRewardFromDifficultyRanges(difficultyLevel);
        if (reward != null) {
            rewardLootTableId = reward.rewardLootTable();
            keyCount = reward.rewardCount();
        }
        if (presetWaves.containsKey(difficultyLevel)) {
            PresetWave wave = presetWaves.get(difficultyLevel);
            rewardLootTableId = wave.rewardLootTable;
            keyCount = wave.rewardCount;
        }
        if ((lootCountCoefPerBlocks = altarBlockEntity.getLootTableCountCoefficientPerBlocks()) != 0.0) {
            double distance = Math.sqrt(pPos.m_123331_((Vec3i)BlockPos.f_121853_));
            double thousands = Math.floor(distance / 1000.0);
            double newKeyCount = (double)keyCount * (1.0 + lootCountCoefPerBlocks * thousands);
            int guaranteed = (int)Math.floor(newKeyCount);
            double fraction = newKeyCount - (double)guaranteed;
            if (pLevel.f_46441_.m_188500_() < fraction) {
                ++guaranteed;
            }
            keyCount = guaranteed;
        }
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(new ResourceLocation(rewardLootTableId));
            if (lootTable == LootTable.f_79105_ && !rewardLootTableId.equals("minecraft:empty")) {
                rewardLootTableId = "skyarena:battle_rewards/crimson_key";
                lootTable = serverLevel.m_7654_().m_278653_().m_278676_(new ResourceLocation(rewardLootTableId));
            }
            if (lootTable != LootTable.f_79105_) {
                LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)pPlayer.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)pPlayer).m_287235_(LootContextParamSets.f_81416_);
                for (int i = 0; i < keyCount; ++i) {
                    ObjectArrayList lootItems = lootTable.m_287195_(lootParams);
                    for (ItemStack stack : lootItems) {
                        ItemEntity rewardEntity = new ItemEntity(pLevel, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), stack);
                        pLevel.m_7967_((Entity)rewardEntity);
                    }
                }
            }
        }
        if (altarBlockEntity.getBattleDifficultyLevel() >= altarBlockEntity.getDifficultyLevel(pPlayer)) {
            altarBlockEntity.increaseDifficultyLevel(pPlayer);
        }
        if (!altarBlockEntity.isAutoWaveRun()) {
            pLevel.m_5594_(null, pPos, SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            pLevel.m_6269_(null, (Entity)pPlayer, SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        altarBlockEntity.setBattlePhaseActive(false);
        altarBlockEntity.stopMusic();
        altarBlockEntity.setBattleEndTime(pLevel.m_46467_());
    }

    public void sendDiscordInvite(Player player) {
        Style discordStyle = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/ZMKnAB92GZ")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.skyarena.discord.hover"))).m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true));
        MutableComponent discord = Component.m_237113_((String)"Discord").m_130948_(discordStyle);
        player.m_213846_((Component)Component.m_237115_((String)"message.skyarena.discord.line1"));
        player.m_213846_((Component)Component.m_237115_((String)"message.skyarena.discord.line2"));
        player.m_213846_((Component)Component.m_237110_((String)"message.skyarena.discord.line3", (Object[])new Object[]{discord}));
    }

    private void handleVictoryTriggers(AltarBlockEntity altarBlockEntity, Player pPlayer) {
        int difficultyLevel = altarBlockEntity.getDifficultyLevel(pPlayer);
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            DifficultyLevel1.INSTANCE.trigger(serverPlayer);
            if (difficultyLevel >= 1) {
                DifficultyLevel1.INSTANCE.trigger(serverPlayer);
            }
            if (difficultyLevel >= 5) {
                DifficultyLevel5.INSTANCE.trigger(serverPlayer);
            }
            if (difficultyLevel >= 10) {
                DifficultyLevel10.INSTANCE.trigger(serverPlayer);
            }
            if (difficultyLevel >= 20) {
                DifficultyLevel20.INSTANCE.trigger(serverPlayer);
            }
            if (difficultyLevel >= 50) {
                DifficultyLevel50.INSTANCE.trigger(serverPlayer);
            }
            if (difficultyLevel >= 100) {
                DifficultyLevel100.INSTANCE.trigger(serverPlayer);
            }
        }
    }

    private void setEnvironment(Level pLevel, Player pPlayer, boolean isNight, boolean isRain) {
        if (isNight) {
            this.setNightTime(pLevel, pPlayer);
        }
        if (isRain) {
            this.setRain(pLevel);
        }
    }

    private void setNightTime(Level pLevel, Player pPlayer) {
        if (!(pLevel instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        long currentTime = serverLevel.m_46468_();
        long dayProgress = currentTime % 24000L;
        long newTime = currentTime - dayProgress + 18000L;
        if (dayProgress <= 18000L && currentTime > 24000L) {
            newTime -= 24000L;
        }
        for (ServerLevel serverlevel : pPlayer.m_20194_().m_129785_()) {
            serverlevel.m_8615_(newTime);
        }
    }

    private void setRain(Level pLevel) {
        ServerLevel serverLevel = (ServerLevel)pLevel;
        serverLevel.m_8606_(0, 6000, true, false);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new AltarBlockEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            return true;
        }
        return false;
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false && fluid == Fluids.f_76193_;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(level, pos, state, placer, itemStack);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean isWaterAbove = level.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_49990_;
        BlockPos posAbove = pos.m_7494_();
        BlockState topBlockState = (BlockState)((BlockState)((Block)ModBlocks.ALTAR_BATTLE_TOP.get()).m_49966_().m_61124_((Property)AltarBlockTop.FACING, (Comparable)facing)).m_61124_((Property)AltarBlockTop.WATERLOGGED, (Comparable)Boolean.valueOf(isWaterAbove));
        level.m_7731_(posAbove, topBlockState, 3);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AltarBlockEntity) {
            AltarBlockEntity altarBlockEntity = (AltarBlockEntity)blockEntity;
            altarBlockEntity.loadArenaConfig(altarBlockEntity.getArenaType());
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockPos abovePos = pos.m_7494_();
            if (level.m_8055_(abovePos).m_60734_() == ModBlocks.ALTAR_BATTLE_TOP.get()) {
                level.m_46961_(abovePos, false);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return AltarBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntity.ALTAR_BLOCK_ENTITY.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }
}

