/*
 * Decompiled with CFR 0.152.
 */
package sleys.epicfight_edp.wom_mixins;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.skill.weaponinnate.SolarArcanaSkill;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@Mixin(value={SolarArcanaSkill.class})
public class SolarArcanaSkillMixin {
    @Unique
    private static final UUID EVENT_UUID = UUID.fromString("b6b0ee46-56b3-4008-9fba-d2594b1e2676");

    @Inject(method={"onInitiate"}, at={@At(value="HEAD")}, remap=false)
    private void injectOnInitiate(SkillContainer container, CallbackInfo ci) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            Item registryItem;
            ServerPlayerPatch patch = (ServerPlayerPatch)event.getPlayerPatch();
            CapabilityItem capability = patch.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            Item itemPlayer = ((ServerPlayer)patch.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            if (!itemPlayer.equals(registryItem = (Item)WOMItems.SOLAR.get()) && capability.getPassiveSkill() == WOMSkills.SOLAR_PASSIVE) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)true);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID, event -> {
            Item registryItem;
            ServerPlayerPatch patch = (ServerPlayerPatch)event.getPlayerPatch();
            CapabilityItem capability = patch.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            Item itemPlayer = ((ServerPlayer)patch.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            if (!itemPlayer.equals(registryItem = (Item)WOMItems.SOLAR.get()) && capability.getPassiveSkill() == WOMSkills.SOLAR_PASSIVE) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)false);
            }
        });
    }

    @Inject(method={"onRemoved"}, at={@At(value="HEAD")}, remap=false)
    private void injectOnRemoved(@NotNull SkillContainer container, CallbackInfo ci) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID);
    }
}

