/*
 * Decompiled with CFR 0.152.
 */
package sleys.epicfight_edp.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.world.capabilities.item.Style;

public class CondicionalSwingTrail {
    public static final Logger LOGGER = LogManager.getLogger(CondicionalSwingTrail.class);
    private static final Map<ResourceLocation, AdvancedSwingTrails> swingTrailData = new ConcurrentHashMap<ResourceLocation, AdvancedSwingTrails>();
    private static boolean loaded = false;

    public static void reloadConfigs() {
        swingTrailData.clear();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        String directoryPath = "item_skins_parameters";
        try {
            Map resources = resourceManager.m_214159_(directoryPath, path -> path.m_135815_().endsWith(".json"));
            if (resources.isEmpty()) {
                LOGGER.info("[Epic Fight - EDP] No se encontraron archivos de parametrizaci\u00f3n avanzada para Swing Trails");
                return;
            }
            LOGGER.info("Cargando {} archivos de parametrizaci\u00f3n:", (Object)resources.size());
            for (Map.Entry entry : resources.entrySet()) {
                try {
                    CondicionalSwingTrail.loadConfigFromResource((Resource)entry.getValue(), (ResourceLocation)entry.getKey());
                }
                catch (Exception e) {
                    LOGGER.error("[Epic Fight - EDP] Error cargando archivo: {}", entry.getKey(), (Object)e);
                }
            }
            LOGGER.info("[Epic Fight - EDP] Configuraci\u00f3n de Swing Trails cargada correctamente. {} registros.", (Object)swingTrailData.size());
        }
        catch (Exception e) {
            LOGGER.error("[Epic Fight - EDP] Error cargando configuraci\u00f3n de parametrizaci\u00f3n", (Throwable)e);
        }
    }

    private static void loadConfigFromResource(Resource resource, ResourceLocation resourceLocation) {
        try (InputStream stream = resource.m_215507_();){
            String json = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            if (root.has("trails") && root.get("trails").isJsonArray()) {
                JsonArray trailsArray = root.getAsJsonArray("trails");
                for (JsonElement element : trailsArray) {
                    CondicionalSwingTrail.processTrailEntry(element.getAsJsonObject(), resourceLocation);
                }
            } else {
                for (Map.Entry entry : root.entrySet()) {
                    AdvancedSwingTrails trail;
                    ResourceLocation itemId = ResourceLocation.m_135820_((String)((String)entry.getKey()));
                    if (itemId == null || !((JsonElement)entry.getValue()).isJsonObject() || (trail = CondicionalSwingTrail.parseTrailConfig(((JsonElement)entry.getValue()).getAsJsonObject())) == null) continue;
                    swingTrailData.put(itemId, trail);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Epic Fight - EDP] Error procesando archivo: {}", (Object)resourceLocation, (Object)e);
        }
    }

    private static void processTrailEntry(JsonObject trailObj, ResourceLocation source) {
        if (!trailObj.has("item")) {
            LOGGER.warn("[Epic Fight - EDP] Entrada sin campo 'item' en {}", (Object)source);
            return;
        }
        ResourceLocation itemId = ResourceLocation.m_135820_((String)trailObj.get("item").getAsString());
        if (itemId == null) {
            LOGGER.warn("[Epic Fight - EDP] ID de item inv\u00e1lido: {}", (Object)trailObj.get("item").getAsString());
            return;
        }
        AdvancedSwingTrails trail = CondicionalSwingTrail.parseTrailConfig(trailObj);
        if (trail != null) {
            swingTrailData.put(itemId, trail);
        }
    }

    private static AdvancedSwingTrails parseTrailConfig(JsonObject json) {
        try {
            boolean perStyle = json.has("per_style") && json.get("per_style").getAsBoolean();
            HashMap<Style, ResourceLocation> styleTrailMap = new HashMap<Style, ResourceLocation>();
            if (json.has("style_config") && json.get("style_config").isJsonArray()) {
                JsonArray configs = json.getAsJsonArray("style_config");
                for (JsonElement e : configs) {
                    JsonObject obj = e.getAsJsonObject();
                    if (!obj.has("style") || !obj.has("trail_texture")) continue;
                    try {
                        Style style = (Style)Style.ENUM_MANAGER.getOrThrow(obj.get("style").getAsString());
                        ResourceLocation trail = ResourceLocation.m_135820_((String)obj.get("trail_texture").getAsString());
                        styleTrailMap.put(style, trail);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("[Epic Fight - EDP] Entrada de configuraci\u00f3n de Style invalida: {}", (Object)obj.toString());
                    }
                }
            }
            ResourceLocation callbackTrail = null;
            if (json.has("callback_trail")) {
                callbackTrail = ResourceLocation.m_135820_((String)json.get("callback_trail").getAsString());
            }
            return new AdvancedSwingTrails(perStyle, styleTrailMap, callbackTrail);
        }
        catch (Exception e) {
            LOGGER.error("[Epic Fight - EDP] Error parseando configuraci\u00f3n de trail", (Throwable)e);
            return null;
        }
    }

    public static AdvancedSwingTrails getAdvancedSwingTrails(ItemStack item) {
        if (!loaded || item.m_41619_()) {
            return AdvancedSwingTrails.DEFAULT;
        }
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
        if (id != null && swingTrailData.containsKey(id)) {
            return swingTrailData.get(id);
        }
        return AdvancedSwingTrails.DEFAULT;
    }

    public record AdvancedSwingTrails(boolean perStyle, Map<Style, ResourceLocation> styleTrails, @Nullable ResourceLocation callbackSwingTrail) {
        public static final AdvancedSwingTrails DEFAULT = new AdvancedSwingTrails(false, Map.of(), null);

        public boolean hasTrail() {
            return this.perStyle || this.callbackSwingTrail != null;
        }
    }

    public static class RegisterSwingTrailData {
        @SubscribeEvent
        public static void onClientLogin(ClientPlayerNetworkEvent.LoggingIn event) {
            if (!loaded) {
                loaded = true;
                CondicionalSwingTrail.reloadConfigs();
            }
        }
    }
}

