/*
 * Decompiled with CFR 0.152.
 */
package sleys.epicfight_edp.passives;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import sleys.epicfight_edp.capability.EDPStyles;
import sleys.epicfight_edp.client.EDPCombatKeyBinding;
import sleys.epicfight_edp.config.EpicFightEDPConfig;
import sleys.lazyutilities.core.utilities.network.CTSFocalTagSyncSender;
import sleys.lazyutilities.core.utilities.network.STCFocalTagSyncSender;
import sleys.lazyutilities.modules.epicfight.annotations.GlobalSkill;
import sleys.lazyutilities.modules.epicfight.forgeevents.GlobalSkillEvent;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ChargedAttackPassive {
    private static final String PressedTimeKey = "epicfight_edp.charged_attack.key.time";
    private static final String PressedCastKey = "epicfight_edp.charged_attack.key.cast";
    private static final String CastDurationKey = "epicfight_edp.charged_attack.key.cast_duration";
    private static final UUID EVENT_UUID = UUID.fromString("f47ac10b-58cc-4372-a567-0e02b2c3d469");
    private static final int MaxTickChargedEvent = 10;
    private static final int CastPersistTicks = 10;
    private static final float CostStamina = 2.0f;
    private final String isAttackAnimation = "epicfight_edp.charged_attack.key.attack_animation";

    public static String getPressedCastKey() {
        return PressedCastKey;
    }

    @GlobalSkill(modId="epicfight_edp", keySkill="charged_attack")
    public void onInitiateChargedSkill(GlobalSkillEvent.ActivationEvent event) {
        event.getPrecursorEvent().getPlayerPatch().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID, attackPhaseEndEvent -> {
            PlayerPatch playerPatch = attackPhaseEndEvent.getPlayerPatch();
            Style playerStyle = playerPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)playerPatch);
            StaticAnimation playerAnimation = attackPhaseEndEvent.getAnimation();
            boolean isAttacking = ((Player)playerPatch.getOriginal()).getPersistentData().m_128471_("epicfight_edp.charged_attack.key.attack_animation");
            for (EDPStyles handStyle : EDPStyles.values()) {
                if (playerStyle.equals((Object)handStyle) && playerAnimation instanceof AttackAnimation) {
                    ((Player)playerPatch.getOriginal()).getPersistentData().m_128379_("epicfight_edp.charged_attack.key.attack_animation", true);
                    STCFocalTagSyncSender.sendBoolean((ServerPlayer)((ServerPlayer)playerPatch.getOriginal()), (String)"epicfight_edp.charged_attack.key.attack_animation", (boolean)true);
                    float actuallyStamina = playerPatch.getStamina();
                    float newStamina = actuallyStamina - this.getCorrectlyStaminaCost(playerPatch) < 0.0f ? 0.0f : actuallyStamina - this.getCorrectlyStaminaCost(playerPatch);
                    playerPatch.setStamina(newStamina);
                    continue;
                }
                if (!isAttacking) continue;
                ((Player)playerPatch.getOriginal()).getPersistentData().m_128379_("epicfight_edp.charged_attack.key.attack_animation", false);
            }
        });
        event.getPrecursorEvent().getPlayerPatch().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, dealDamageEvent -> {
            PlayerPatch playerPatch = dealDamageEvent.getPlayerPatch();
            Style playerStyle = playerPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)playerPatch);
            boolean isAttacking = ((Player)playerPatch.getOriginal()).getPersistentData().m_128471_("epicfight_edp.charged_attack.key.attack_animation");
            for (EDPStyles handStyle : EDPStyles.values()) {
                if (!playerStyle.equals((Object)handStyle) || !isAttacking) continue;
                float actuallyDamage = ((LivingDamageEvent)dealDamageEvent.getForgeEvent()).getAmount();
                float newDamage = actuallyDamage * 1.2f;
                ((LivingDamageEvent)dealDamageEvent.getForgeEvent()).setAmount(newDamage);
            }
        });
    }

    @GlobalSkill(modId="epicfight_edp", keySkill="charged_attack")
    public void onRemovedChargedSkill(GlobalSkillEvent.DeactivationEvent event) {
        event.getPrecursorEvent().getPlayerPatch().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID);
        event.getPrecursorEvent().getPlayerPatch().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        event.getPrecursorEvent().getPlayerPatch().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID);
    }

    @GlobalSkill(modId="epicfight_edp", keySkill="charged_attack")
    public void onTickPassiveChargedSkill(GlobalSkillEvent.ContinuousEvent event) {
        PlayerPatch patchCaster = event.getPrecursorEvent().getPlayerPatch();
        Player caster = (Player)patchCaster.getOriginal();
        CompoundTag data = caster.getPersistentData();
        float allowIs = event.getPrecursorEvent().getPlayerPatch().getStamina();
        int time = data.m_128451_(PressedTimeKey);
        boolean cast = data.m_128471_(PressedCastKey);
        int castDuration = data.m_128451_(CastDurationKey);
        if (allowIs > this.getCorrectlyStaminaCost(patchCaster)) {
            if (event.getPrecursorEvent().isClientSide()) {
                if (EDPCombatKeyBinding.chargedAttackKeyBinding.m_90857_()) {
                    if (++time > 10) {
                        time = 10;
                    }
                    data.m_128405_(PressedTimeKey, time);
                    CTSFocalTagSyncSender.sendInt((String)PressedTimeKey, (int)time);
                    if (time == 10 && !cast) {
                        data.m_128379_(PressedCastKey, true);
                        CTSFocalTagSyncSender.sendBoolean((String)PressedCastKey, (boolean)true);
                    }
                } else {
                    if (cast) {
                        if (++castDuration >= 10) {
                            data.m_128405_(CastDurationKey, 0);
                            CTSFocalTagSyncSender.sendInt((String)CastDurationKey, (int)0);
                            data.m_128379_(PressedCastKey, false);
                            CTSFocalTagSyncSender.sendBoolean((String)PressedCastKey, (boolean)false);
                        } else {
                            data.m_128405_(CastDurationKey, castDuration);
                            CTSFocalTagSyncSender.sendInt((String)CastDurationKey, (int)castDuration);
                        }
                    }
                    if (time != 0) {
                        data.m_128405_(PressedTimeKey, 0);
                        CTSFocalTagSyncSender.sendInt((String)PressedTimeKey, (int)0);
                    }
                }
            }
        } else if (cast && event.getPrecursorEvent().isClientSide()) {
            data.m_128405_(CastDurationKey, 0);
            CTSFocalTagSyncSender.sendInt((String)CastDurationKey, (int)0);
            data.m_128379_(PressedCastKey, false);
            CTSFocalTagSyncSender.sendBoolean((String)PressedCastKey, (boolean)false);
        }
    }

    private float getCorrectlyStaminaCost(PlayerPatch<?> patch) {
        if (EpicFightEDPConfig.getUseStaminaInChargedAttacks()) {
            if (EpicFightEDPConfig.getUseWeightInChargedAttacks()) {
                LivingEntity entity = (LivingEntity)patch.getOriginal();
                AttributeInstance weightAttr = entity.m_21051_((Attribute)EpicFightAttributes.WEIGHT.get());
                float weight = weightAttr != null ? ((float)weightAttr.m_22135_() != 0.0f ? (float)weightAttr.m_22135_() : 1.0f) : 1.0f;
                return 2.0f * (1.0f + weight * 0.05f) / EpicFightEDPConfig.getWeightValueInChargedAttacks();
            }
            return 2.0f;
        }
        return 0.0f;
    }
}

