/*
 * Decompiled with CFR 0.152.
 */
package sleys.epicfight_edp.mixins;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sleys.lazyutilities.modules.epicfight.LZEpicFightMod;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;

@Mixin(value={WeaponTypeReloadListener.class})
public abstract class WeaponTypeReloadListenerMixin {
    @Inject(method={"deserializeWeaponCapabilityBuilder"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void injectPassiveSkill(ResourceLocation rl, CompoundTag tag, CallbackInfoReturnable<WeaponCapability.Builder> cir) {
        WeaponCapability.Builder builder = (WeaponCapability.Builder)cir.getReturnValue();
        if (tag.m_128441_("passive_skill")) {
            String skillId = tag.m_128461_("passive_skill");
            Skill skill = SkillManager.getSkill((String)skillId);
            if (skill != null) {
                builder.passiveSkill(skill);
                LZEpicFightMod.LOGGER.info("Asignando la habilidad pasiva '{}' A la categoria '{}'", (Object)skill, (Object)rl);
            } else {
                LZEpicFightMod.LOGGER.warn("La habilidad pasiva '{}' No fue encontrada, fallo al asignarse a la categoria '{}'", (Object)skillId, (Object)rl);
            }
        }
        if (tag.m_128441_("zoom_in_type")) {
            String zoom_in_type = tag.m_128461_("zoom_in_type");
            CapabilityItem.ZoomInType zoomInType = null;
            switch (zoom_in_type) {
                case "none": {
                    zoomInType = CapabilityItem.ZoomInType.NONE;
                    break;
                }
                case "always": {
                    zoomInType = CapabilityItem.ZoomInType.ALWAYS;
                    break;
                }
                case "use_tick": {
                    zoomInType = CapabilityItem.ZoomInType.USE_TICK;
                    break;
                }
                case "aiming": {
                    zoomInType = CapabilityItem.ZoomInType.AIMING;
                    break;
                }
                case "custom": {
                    zoomInType = CapabilityItem.ZoomInType.CUSTOM;
                }
            }
            if (zoomInType != null) {
                builder.zoomInType(zoomInType);
                LZEpicFightMod.LOGGER.info("Asignando el tipo de zoom '{}' A la categoria '{}'", (Object)zoomInType, (Object)rl);
            } else {
                LZEpicFightMod.LOGGER.info("El zoom '{}' No es una entrada de zoom convertible y valida para '{}'", (Object)zoom_in_type, (Object)rl);
            }
        }
        cir.setReturnValue((Object)builder);
    }
}

