/*
 * Decompiled with CFR 0.152.
 */
package sleys.epicfight_edp.mixins;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sleys.epicfight_edp.registry.CondicionalSwingTrail;
import sleys.lazyutilities.modules.epicfight.capability.AnimationRenderContext;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;

@Mixin(value={RenderItemBase.class})
public class SwingTrailMixinClient {
    @Inject(method={"trailInfo"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void modifyTrailInfo(CallbackInfoReturnable<TrailInfo> cir) {
        TrailInfo original = (TrailInfo)cir.getReturnValue();
        if (original == null || original.texturePath() == null) {
            return;
        }
        LivingEntityPatch entityPatch = AnimationRenderContext.getCurrentEntityPatch();
        if (entityPatch == null) {
            return;
        }
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        if (entity == null) {
            return;
        }
        InteractionHand hand = original.hand() != null ? original.hand() : InteractionHand.MAIN_HAND;
        ItemStack item = entity.m_21120_(hand);
        CondicionalSwingTrail.AdvancedSwingTrails config = CondicionalSwingTrail.getAdvancedSwingTrails(item);
        if (!config.hasTrail()) {
            return;
        }
        ResourceLocation newTexture = this.extended_datapacks$resolveTrailTexture(config, entityPatch);
        if (newTexture != null && !newTexture.equals((Object)original.texturePath())) {
            TrailInfo modified = this.extended_datapacks$createModifiedTrailInfo(original, newTexture);
            cir.setReturnValue((Object)modified);
        }
    }

    @Unique
    private ResourceLocation extended_datapacks$resolveTrailTexture(CondicionalSwingTrail.AdvancedSwingTrails config, LivingEntityPatch<?> entityPatch) {
        if (config.perStyle() && !config.styleTrails().isEmpty()) {
            CapabilityItem currentCapability = entityPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (currentCapability != null) {
                Style currentStyle = currentCapability.getStyle(entityPatch);
                ResourceLocation styleTexture = config.styleTrails().get(currentStyle);
                if (styleTexture != null) {
                    return styleTexture;
                }
            }
            if (config.callbackSwingTrail() != null) {
                return config.callbackSwingTrail();
            }
        }
        return null;
    }

    @Unique
    private TrailInfo extended_datapacks$createModifiedTrailInfo(TrailInfo original, ResourceLocation newTexture) {
        return new TrailInfo(original.start(), original.end(), original.joint(), original.particle(), original.startTime(), original.endTime(), original.fadeTime(), original.rCol(), original.gCol(), original.bCol(), original.interpolateCount(), original.trailLifetime(), original.updateInterval(), original.blockLight(), original.skyLight(), newTexture, original.hand());
    }
}

