/*
 * Decompiled with CFR 0.152.
 */
package sleys.epicfight_edp.conditions.entity;

import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import sleys.epicfight_edp.conditions.CommonUtilities;
import sleys.epicfight_edp.conditions.ComparisonType;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.PopupBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class PassiveSkillDataKeyFloatCondition
extends Condition.EntityPatchCondition {
    private ResourceLocation skillFloatDataKey;
    private Float expectedValue;
    private Float tolerance;
    private ComparisonType comparisonType;

    public PassiveSkillDataKeyFloatCondition read(CompoundTag tag) {
        String keyPath = (String)this.assertTag("skill_data_key", "string", tag, StringTag.class, CompoundTag::m_128461_);
        if (keyPath == null) {
            throw new NoSuchElementException("Condition error: Float Skill Datakey can't be null in " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.skillFloatDataKey = ResourceLocation.parse((String)keyPath);
        if (!tag.m_128441_("expected_value")) {
            throw new NoSuchElementException("Expected value can't be null in " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.expectedValue = Float.valueOf(tag.m_128457_("expected_value"));
        if (tag.m_128441_("comparison_type")) {
            String comparisonStr = tag.m_128461_("comparison_type");
            this.comparisonType = ComparisonType.fromString(comparisonStr);
        } else {
            this.comparisonType = ComparisonType.EQUAL;
        }
        this.tolerance = tag.m_128441_("tolerance") ? Float.valueOf(tag.m_128457_("tolerance")) : Float.valueOf(0.001f);
        return this;
    }

    public boolean predicate(LivingEntityPatch<?> entityPatch) {
        if (entityPatch instanceof PlayerPatch) {
            PlayerPatch playerPatch = (PlayerPatch)entityPatch;
            SkillContainer skillContainer = playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE);
            if (skillContainer == null) {
                return false;
            }
            SkillDataManager skillManager = skillContainer.getDataManager();
            if (skillManager == null) {
                return false;
            }
            SkillDataKey key = (SkillDataKey)((IForgeRegistry)SkillDataKeys.REGISTRY.get()).getValue(this.skillFloatDataKey);
            if (key == null) {
                return false;
            }
            if (skillManager.hasData(key)) {
                Object value = skillManager.getDataValue(key);
                Float floatValue = null;
                if (value instanceof Float) {
                    floatValue = (Float)value;
                } else if (value instanceof Number) {
                    floatValue = Float.valueOf(((Number)value).floatValue());
                }
                if (floatValue != null) {
                    return CommonUtilities.compareFloatValues(floatValue.floatValue(), this.expectedValue.floatValue(), this.comparisonType, this.tolerance.floatValue());
                }
            }
        }
        return false;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        if (this.skillFloatDataKey != null) {
            tag.m_128359_("skill_data_key", this.skillFloatDataKey.toString());
        }
        if (this.expectedValue != null) {
            tag.m_128350_("expected_value", this.expectedValue.floatValue());
        }
        if (this.comparisonType != null) {
            tag.m_128359_("comparison_type", this.comparisonType.getSymbol());
        }
        if (this.tolerance != null) {
            tag.m_128350_("tolerance", this.tolerance.floatValue());
        }
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        PopupBox.RegistryPopupBox popupBox = new PopupBox.RegistryPopupBox(screen, screen.getMinecraft().f_91062_, 0, 0, 0, 0, null, null, (Component)Component.m_237113_((String)"Skill Data Key"), (IForgeRegistry)SkillDataKeys.REGISTRY.get(), null);
        return List.of(Condition.ParameterEditor.of(rl -> StringTag.m_129297_((String)rl.toString()), tag -> ResourceLocation.parse((String)ParseUtil.nullOrToString((Object)tag, Tag::m_7916_)), (AbstractWidget)popupBox));
    }
}

