/*
 * Decompiled with CFR 0.152.
 */
package sleys.epicfight_edp.conditions.charged;

import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import sleys.epicfight_edp.passives.ChargedAttackPassive;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.PopupBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class ChargedAttackCondition
extends Condition.EntityPatchCondition {
    private Boolean offHandCapability;

    public ChargedAttackCondition read(CompoundTag tag) {
        if (!tag.m_128441_("allow_two_hand_compatibility")) {
            throw new NoSuchElementException("Capability Hand can't be null in " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.offHandCapability = tag.m_128471_("allow_two_hand_compatibility");
        return this;
    }

    public boolean predicate(LivingEntityPatch<?> entityPatch) {
        if (entityPatch instanceof PlayerPatch) {
            PlayerPatch playerPatch = (PlayerPatch)entityPatch;
            Player player = (Player)playerPatch.getOriginal();
            CapabilityItem itemCapabilityMain = playerPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            CapabilityItem itemCapabilityOff = playerPatch.getHoldingItemCapability(InteractionHand.OFF_HAND);
            if (itemCapabilityMain == null) {
                return false;
            }
            WeaponCategory mainHandCategory = itemCapabilityMain.getWeaponCategory();
            WeaponCategory offHandCategory = itemCapabilityOff != null ? itemCapabilityOff.getWeaponCategory() : null;
            boolean isChargedAttack = player.getPersistentData().m_128471_(ChargedAttackPassive.getPressedCastKey());
            if (isChargedAttack) {
                boolean sameCategory = mainHandCategory.equals(offHandCategory);
                if (this.offHandCapability.booleanValue() && sameCategory) {
                    return true;
                }
                if (!this.offHandCapability.booleanValue() && !sameCategory) {
                    return true;
                }
            }
        }
        return false;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        if (this.offHandCapability != null) {
            tag.m_128379_("allow_two_hand_compatibility", this.offHandCapability.booleanValue());
        }
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        PopupBox.RegistryPopupBox popupBox = new PopupBox.RegistryPopupBox(screen, screen.getMinecraft().f_91062_, 0, 0, 0, 0, null, null, (Component)Component.m_237113_((String)"THIS DOES NOTHING; IT JUST PREVENTS THE CRASH"), (IForgeRegistry)SkillDataKeys.REGISTRY.get(), null);
        return List.of(Condition.ParameterEditor.of(rl -> StringTag.m_129297_((String)rl.toString()), tag -> ResourceLocation.parse((String)ParseUtil.nullOrToString((Object)tag, Tag::m_7916_)), (AbstractWidget)popupBox));
    }
}

