/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import java.util.HashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class PlayerOriginComponent
implements OriginComponent {
    private final HashMap<OriginLayer, Origin> origins = new HashMap();
    private final class_1657 player;
    private boolean selectingOrigin = false;
    private boolean hadOriginBefore = false;
    private int invulnerabilityTicks = 0;

    public PlayerOriginComponent(class_1657 player) {
        this.player = player;
    }

    @Override
    public boolean hasSelectionInvulnerability() {
        return this.invulnerabilityTicks > 0;
    }

    @Override
    public boolean isSelectingOrigin() {
        return this.selectingOrigin;
    }

    @Override
    public void selectingOrigin(boolean selectingOrigin) {
        this.selectingOrigin = selectingOrigin;
        if (selectingOrigin) {
            this.invulnerabilityTicks = 60;
        }
    }

    @Override
    public boolean hasAllOrigins() {
        return OriginLayers.getLayers().stream().allMatch(layer -> !layer.isEnabled() || layer.getOrigins().isEmpty() || this.origins.containsKey(layer) && this.origins.get(layer) != Origin.EMPTY);
    }

    @Override
    public HashMap<OriginLayer, Origin> getOrigins() {
        return this.origins;
    }

    @Override
    public boolean hasOrigin(OriginLayer layer) {
        return this.origins.containsKey(layer) && this.origins.get(layer) != null && this.origins.get(layer) != Origin.EMPTY;
    }

    @Override
    public Origin getOrigin(OriginLayer layer) {
        return this.origins.get(layer);
    }

    @Override
    public boolean hadOriginBefore() {
        return this.hadOriginBefore;
    }

    @Override
    public void setOrigin(OriginLayer layer, Origin origin) {
        class_1657 class_16572;
        Origin oldOrigin = this.getOrigin(layer);
        if (origin == oldOrigin) {
            return;
        }
        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
        this.grantPowersFromOrigin(origin, powerComponent);
        this.origins.put(layer, origin);
        if (oldOrigin != null && !origin.getIdentifier().equals((Object)oldOrigin.getIdentifier())) {
            powerComponent.removeAllPowersFromSource(oldOrigin.getIdentifier());
        }
        if (this.hasAllOrigins()) {
            this.hadOriginBefore = true;
        }
        if ((class_16572 = this.player) instanceof class_3222) {
            class_3222 spe = (class_3222)class_16572;
            ChoseOriginCriterion.INSTANCE.trigger(spe, origin);
        }
    }

    private void grantPowersFromOrigin(Origin origin, PowerHolderComponent powerComponent) {
        class_2960 source = origin.getIdentifier();
        for (PowerType<?> powerType : origin.getPowerTypes()) {
            if (powerComponent.hasPower(powerType, source)) continue;
            powerComponent.addPower(powerType, source);
        }
    }

    private void revokeRemovedPowers(Origin origin, PowerHolderComponent powerComponent) {
        class_2960 sourceId = origin.getIdentifier();
        powerComponent.getPowersFromSource(sourceId).stream().filter(pt -> !origin.hasPowerType((PowerType<?>)pt)).forEach(pt -> powerComponent.removePower(pt, sourceId));
    }

    public void tick() {
        if (!this.selectingOrigin && this.invulnerabilityTicks > 0) {
            --this.invulnerabilityTicks;
        }
    }

    public void readFromNbt(@NotNull class_2487 compoundTag) {
        int i;
        if (this.player == null) {
            Origins.LOGGER.error("Player was null in PlayerOriginComponent#fromTag! This is not supposed to happen D:");
            return;
        }
        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
        this.origins.clear();
        if (compoundTag.method_10545("Origin")) {
            try {
                OriginLayer defaultOriginLayer = OriginLayers.getLayer(Origins.identifier("origin"));
                this.origins.put(defaultOriginLayer, OriginRegistry.get(new class_2960(compoundTag.method_10558("Origin"))));
            }
            catch (Exception ignored) {
                Origins.LOGGER.warn("Player {} had old origin which could not be migrated: {}", (Object)this.player.method_5477().getString(), (Object)compoundTag.method_10558("Origin"));
            }
        } else {
            class_2499 originLayersNbt = compoundTag.method_10554("OriginLayers", 10);
            for (i = 0; i < originLayersNbt.size(); ++i) {
                class_2487 originLayerNbt = originLayersNbt.method_10602(i);
                try {
                    class_2960 layerId = new class_2960(originLayerNbt.method_10558("Layer"));
                    class_2960 originId = new class_2960(originLayerNbt.method_10558("Origin"));
                    OriginLayer layer = OriginLayers.getLayer(layerId);
                    Origin origin = OriginRegistry.get(originId);
                    this.origins.put(layer, origin);
                    if (layer.contains(origin) || origin.isSpecial()) continue;
                    Origins.LOGGER.warn("Origin \"{}\" is not in origin layer \"{}\" and is not considered special, but was found on player {}!", (Object)originId, (Object)layerId, (Object)this.player.method_5477().getString());
                    powerComponent.removeAllPowersFromSource(originId);
                    this.origins.put(layer, Origin.EMPTY);
                    continue;
                }
                catch (Exception e) {
                    Origins.LOGGER.error("There was a problem trying to read origin NBT data of player {}: {}", (Object)this.player.method_5477().getString(), (Object)e.getMessage());
                }
            }
        }
        this.selectingOrigin = compoundTag.method_10577("SelectingOrigin");
        this.hadOriginBefore = compoundTag.method_10577("HadOriginBefore");
        if (this.player.method_37908().field_9236) {
            return;
        }
        for (Origin origin : this.origins.values()) {
            this.grantPowersFromOrigin(origin, powerComponent);
        }
        for (Origin origin : this.origins.values()) {
            this.revokeRemovedPowers(origin, powerComponent);
        }
        if (!compoundTag.method_10545("Powers")) {
            return;
        }
        class_2499 legacyPowersNbt = compoundTag.method_10554("Powers", 10);
        for (i = 0; i < legacyPowersNbt.size(); ++i) {
            class_2487 legacyPowerNbt = legacyPowersNbt.method_10602(i);
            String legacyPowerString = legacyPowerNbt.method_10558("Type");
            try {
                class_2960 legacyPowerId = new class_2960(legacyPowerString);
                PowerType legacyPowerType = PowerTypeRegistry.get((class_2960)legacyPowerId);
                if (!powerComponent.hasPower(legacyPowerType)) continue;
                try {
                    class_2520 legacyPowerData = legacyPowerNbt.method_10580("Data");
                    powerComponent.getPower(legacyPowerType).fromTag(legacyPowerData);
                }
                catch (ClassCastException e) {
                    Origins.LOGGER.warn("Data type of power \"{}\" changed, skipping data for that power on entity {}", (Object)legacyPowerId, (Object)this.player.method_5477().getString());
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.warn("Power data of unregistered power \"{}\" found on player {}, skipping...", (Object)legacyPowerString, (Object)this.player.method_5477().getString());
            }
        }
    }

    public void writeToNbt(@NotNull class_2487 compoundTag) {
        class_2499 originLayersNbt = new class_2499();
        this.origins.forEach((layer, origin) -> {
            class_2487 originLayerNbt = new class_2487();
            originLayerNbt.method_10582("Layer", layer.getIdentifier().toString());
            originLayerNbt.method_10582("Origin", origin.getIdentifier().toString());
            originLayersNbt.add((Object)originLayerNbt);
        });
        compoundTag.method_10566("OriginLayers", (class_2520)originLayersNbt);
        compoundTag.method_10556("SelectingOrigin", this.selectingOrigin);
        compoundTag.method_10556("HadOriginBefore", this.hadOriginBefore);
    }

    @Override
    public void sync() {
        OriginComponent.sync(this.player);
    }
}

