/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.command.LayerArgumentType;
import io.github.apace100.origins.command.OriginArgumentType;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class OriginCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"origin").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(class_2170.method_9244((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(OriginCommand::setOrigin)))))).then(class_2170.method_9247((String)"has").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(class_2170.method_9244((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(OriginCommand::hasOrigin)))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(OriginCommand::getOrigin))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"gui").executes(commandContext -> OriginCommand.openMultipleLayerScreens((CommandContext<class_2168>)commandContext, TargetType.INVOKER))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(commandContext -> OriginCommand.openMultipleLayerScreens((CommandContext<class_2168>)commandContext, TargetType.SPECIFY))).then(class_2170.method_9244((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(OriginCommand::openSingleLayerScreen))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"random").executes(commandContext -> OriginCommand.randomizeOrigins((CommandContext<class_2168>)commandContext, TargetType.INVOKER))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(commandContext -> OriginCommand.randomizeOrigins((CommandContext<class_2168>)commandContext, TargetType.SPECIFY))).then(class_2170.method_9244((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(OriginCommand::randomizeOrigin)))));
    }

    private static int setOrigin(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(commandContext, (String)"targets");
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        Origin origin = OriginArgumentType.getOrigin(commandContext, "origin");
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        int processedTargets = 0;
        if (origin.equals(Origin.EMPTY) || originLayer.getOrigins().contains(origin.getIdentifier())) {
            for (class_3222 target : targets) {
                OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
                boolean hadOriginBefore = originComponent.hadOriginBefore();
                originComponent.setOrigin(originLayer, origin);
                originComponent.sync();
                OriginComponent.partialOnChosen((class_1657)target, hadOriginBefore, origin);
                ++processedTargets;
            }
            if (processedTargets == 1) {
                serverCommandSource.method_9226(() -> class_2561.method_43469((String)"commands.origin.set.success.single", (Object[])new Object[]{((class_3222)targets.iterator().next()).method_5476().getString(), class_2561.method_43471((String)originLayer.getTranslationKey()), origin.getName()}), true);
            } else {
                int finalProcessedTargets = processedTargets;
                serverCommandSource.method_9226(() -> class_2561.method_43469((String)"commands.origin.set.success.multiple", (Object[])new Object[]{finalProcessedTargets, class_2561.method_43471((String)originLayer.getTranslationKey()), origin.getName()}), true);
            }
        } else {
            serverCommandSource.method_9213((class_2561)class_2561.method_43469((String)"commands.origin.unregistered_in_layer", (Object[])new Object[]{origin.getIdentifier(), originLayer.getIdentifier()}));
        }
        return processedTargets;
    }

    private static int hasOrigin(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(commandContext, (String)"targets");
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        Origin origin = OriginArgumentType.getOrigin(commandContext, "origin");
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        int processedTargets = 0;
        if (origin.equals(Origin.EMPTY) || originLayer.getOrigins().contains(origin.getIdentifier())) {
            for (class_3222 target : targets) {
                OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
                if (!origin.equals(Origin.EMPTY) && !originComponent.hasOrigin(originLayer) || !originComponent.getOrigin(originLayer).equals(origin)) continue;
                ++processedTargets;
            }
            if (processedTargets == 0) {
                serverCommandSource.method_9213((class_2561)class_2561.method_43471((String)"commands.execute.conditional.fail"));
            } else if (processedTargets == 1) {
                serverCommandSource.method_9226(() -> class_2561.method_43471((String)"commands.execute.conditional.pass"), true);
            } else {
                int finalProcessedTargets = processedTargets;
                serverCommandSource.method_9226(() -> class_2561.method_43469((String)"commands.execute.conditional.pass_count", (Object[])new Object[]{finalProcessedTargets}), true);
            }
        } else {
            serverCommandSource.method_9213((class_2561)class_2561.method_43469((String)"commands.origin.unregistered_in_layer", (Object[])new Object[]{origin.getIdentifier(), originLayer.getIdentifier()}));
        }
        return processedTargets;
    }

    private static int getOrigin(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(commandContext, (String)"target");
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        Origin origin = originComponent.getOrigin(originLayer);
        serverCommandSource.method_9226(() -> class_2561.method_43469((String)"commands.origin.get.result", (Object[])new Object[]{target.method_5476().getString(), class_2561.method_43471((String)originLayer.getTranslationKey()), origin.getName(), origin.getIdentifier()}), true);
        return 1;
    }

    private static int openSingleLayerScreen(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        Collection targets = class_2186.method_9312(commandContext, (String)"targets");
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        for (class_3222 target : targets) {
            OriginCommand.openLayerScreen(target, originLayer);
        }
        serverCommandSource.method_9226(() -> class_2561.method_43469((String)"commands.origin.gui.layer", (Object[])new Object[]{targets.size(), class_2561.method_43471((String)originLayer.getTranslationKey())}), true);
        return targets.size();
    }

    private static int openMultipleLayerScreens(CommandContext<class_2168> commandContext, TargetType targetType) throws CommandSyntaxException {
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        ArrayList<class_3222> targets = new ArrayList<class_3222>();
        List<OriginLayer> originLayers = OriginLayers.getLayers().stream().toList();
        switch (targetType.ordinal()) {
            case 0: {
                targets.add(serverCommandSource.method_9207());
                break;
            }
            case 1: {
                targets.addAll(class_2186.method_9312(commandContext, (String)"targets"));
            }
        }
        for (class_3222 target : targets) {
            for (OriginLayer originLayer : originLayers) {
                OriginCommand.openLayerScreen(target, originLayer);
            }
        }
        serverCommandSource.method_9226(() -> class_2561.method_43469((String)"commands.origin.gui.all", (Object[])new Object[]{targets.size()}), false);
        return targets.size();
    }

    private static int randomizeOrigin(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        Collection targets = class_2186.method_9312(commandContext, (String)"targets");
        OriginLayer originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        if (originLayer.isRandomAllowed()) {
            Origin origin = null;
            for (class_3222 target : targets) {
                origin = OriginCommand.getRandomOrigin(target, originLayer);
            }
            if (targets.size() > 1) {
                serverCommandSource.method_9226(() -> class_2561.method_43469((String)"commands.origin.random.success.multiple", (Object[])new Object[]{targets.size(), class_2561.method_43471((String)originLayer.getTranslationKey())}), true);
            } else if (targets.size() == 1) {
                Origin finalOrigin = origin;
                serverCommandSource.method_9226(() -> class_2561.method_43469((String)"commands.origin.random.success.single", (Object[])new Object[]{((class_3222)targets.iterator().next()).method_5476().getString(), finalOrigin.getName(), class_2561.method_43471((String)originLayer.getTranslationKey())}), false);
            }
            return targets.size();
        }
        serverCommandSource.method_9213((class_2561)class_2561.method_43469((String)"commands.origin.random.not_allowed", (Object[])new Object[]{class_2561.method_43471((String)originLayer.getTranslationKey())}));
        return 0;
    }

    private static int randomizeOrigins(CommandContext<class_2168> commandContext, TargetType targetType) throws CommandSyntaxException {
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        ArrayList<class_3222> targets = new ArrayList<class_3222>();
        List<OriginLayer> originLayers = OriginLayers.getLayers().stream().filter(OriginLayer::isRandomAllowed).toList();
        switch (targetType.ordinal()) {
            case 0: {
                targets.add(serverCommandSource.method_9207());
                break;
            }
            case 1: {
                targets.addAll(class_2186.method_9312(commandContext, (String)"targets"));
            }
        }
        for (class_3222 target : targets) {
            for (OriginLayer originLayer : originLayers) {
                OriginCommand.getRandomOrigin(target, originLayer);
            }
        }
        serverCommandSource.method_9226(() -> class_2561.method_43469((String)"commands.origin.random.all", (Object[])new Object[]{targets.size(), originLayers.size()}), false);
        return targets.size();
    }

    private static void openLayerScreen(class_3222 target, OriginLayer originLayer) {
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
        if (originLayer.isEnabled()) {
            originComponent.setOrigin(originLayer, Origin.EMPTY);
        }
        originComponent.selectingOrigin(true);
        originComponent.checkAutoChoosingLayers((class_1657)target, false);
        originComponent.sync();
        if (originComponent.isSelectingOrigin()) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.writeBoolean(false);
            ServerPlayNetworking.send((class_3222)target, (class_2960)ModPackets.OPEN_ORIGIN_SCREEN, (class_2540)buffer);
        }
    }

    private static Origin getRandomOrigin(class_3222 target, OriginLayer originLayer) {
        List<Origin> origins = originLayer.getRandomOrigins((class_1657)target).stream().map(OriginRegistry::get).toList();
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
        Origin origin = origins.get(new Random().nextInt(origins.size()));
        boolean hadOriginBefore = originComponent.hadOriginBefore();
        boolean hadAllOrigins = originComponent.hasAllOrigins();
        originComponent.setOrigin(originLayer, origin);
        originComponent.checkAutoChoosingLayers((class_1657)target, false);
        originComponent.sync();
        if (originComponent.hasAllOrigins() && !hadAllOrigins) {
            OriginComponent.onChosen((class_1657)target, hadOriginBefore);
        }
        Origins.LOGGER.info("Player {} was randomly assigned the origin {} for layer {}", (Object)target.method_5476().getString(), (Object)origin.getIdentifier().toString(), (Object)originLayer.getIdentifier().toString());
        return origin;
    }

    private static enum TargetType {
        INVOKER,
        SPECIFY;

    }
}

