/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.IConditionalGrowingBlock;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.ConfigurableBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.IBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.NoOpBlockGrowth;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class BlockGrowthHandler
extends RegistryAccessJsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final BlockGrowthHandler RELOAD_INSTANCE = new BlockGrowthHandler();
    private static final Map<TickSource, Map<Block, Set<IBlockGrowth>>> GROWTH_FOR_BLOCK = new EnumMap<TickSource, Map<Block, Set<IBlockGrowth>>>(TickSource.class);
    private static final Map<TickSource, Set<IBlockGrowth>> UNIVERSAL_GROWTHS = new EnumMap<TickSource, Set<IBlockGrowth>>(TickSource.class);

    public BlockGrowthHandler() {
        super(GSON, "block_growths");
    }

    public static Optional<Set<IBlockGrowth>> getBlockGrowths(TickSource source, Block block) {
        return Optional.ofNullable(GROWTH_FOR_BLOCK.get((Object)source)).map(m -> (Set)m.get(block));
    }

    public static void tickBlock(TickSource source, BlockState state, ServerLevel level, BlockPos pos) {
        Optional<Set<IBlockGrowth>> growth;
        IConditionalGrowingBlock cb;
        if (!CommonConfigs.BLOCK_GROWTHS.get().booleanValue()) {
            return;
        }
        Block block = state.m_60734_();
        if (block instanceof IConditionalGrowingBlock && !(cb = (IConditionalGrowingBlock)block).canGrow(state)) {
            return;
        }
        com.google.common.base.Supplier biome = Suppliers.memoize(() -> level.m_204166_(pos));
        Set<IBlockGrowth> universalGroup = UNIVERSAL_GROWTHS.get((Object)source);
        if (universalGroup != null) {
            for (IBlockGrowth config : universalGroup) {
                config.tryGrowing(pos, state, level, (Supplier<Holder<Biome>>)biome);
            }
        }
        if ((growth = BlockGrowthHandler.getBlockGrowths(source, state.m_60734_())).isPresent()) {
            for (IBlockGrowth config : growth.get()) {
                config.tryGrowing(pos, state, level, (Supplier<Holder<Biome>>)biome);
            }
        }
    }

    public static void performSkyAccessTick(ServerLevel level, LevelChunk levelChunk, int randomTickSpeed) {
        ChunkPos chunkpos = levelChunk.m_7697_();
        float chance = (float)randomTickSpeed / 48.0f;
        int minX = chunkpos.m_45604_();
        int minZ = chunkpos.m_45605_();
        boolean isRaining = level.m_46471_();
        do {
            if (!(chance > level.m_213780_().m_188501_())) continue;
            BlockPos firstAirPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, level.m_46496_(minX, 0, minZ, 15));
            BlockPos targetPos = firstAirPos.m_7495_();
            BlockState state = level.m_8055_(targetPos);
            TickSource source = TickSource.CLEAR_SKY;
            if (isRaining) {
                Biome biome = (Biome)level.m_204166_(targetPos).m_203334_();
                Biome.Precipitation precipitation = biome.m_264600_(targetPos);
                source = precipitation == Biome.Precipitation.SNOW ? TickSource.SNOW : TickSource.RAIN;
            }
            BlockGrowthHandler.tickBlock(source, state, level, new BlockPos((Vec3i)targetPos));
        } while ((chance -= 1.0f) > 0.0f);
    }

    public void parse(Map<ResourceLocation, JsonElement> jsonMap, RegistryAccess registryAccess) {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        for (Map.Entry<ResourceLocation, JsonElement> e2 : jsonMap.entrySet()) {
            map.put(e2.getKey(), e2.getValue().deepCopy());
        }
        ArrayList<IBlockGrowth> growths = new ArrayList<IBlockGrowth>();
        for (Map.Entry e3 : map.entrySet()) {
            IBlockGrowth g;
            JsonObject jo;
            String name = ((ResourceLocation)e3.getKey()).m_135815_();
            if (CommonConfigs.DISABLED_GROWTHS.get().contains(name.toLowerCase(Locale.ROOT))) continue;
            JsonElement json = (JsonElement)e3.getValue();
            DataResult result = json instanceof JsonObject && (jo = (JsonObject)json).has("builtin") ? BuiltinBlockGrowth.CODEC.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess), (Object)json) : ConfigurableBlockGrowth.CODEC.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess), (Object)json);
            Optional o = result.resultOrPartial(error -> ImmersiveWeathering.LOGGER.error("Failed to read block growth JSON object for {} : {}", e3.getKey(), error));
            if (o.isPresent() && !((g = (IBlockGrowth)o.get()) instanceof NoOpBlockGrowth)) {
                growths.add(g);
            }
            o.ifPresent(growths::add);
        }
        ImmersiveWeathering.LOGGER.info("Loaded {} block growths configurations", (Object)map.size());
        GROWTH_FOR_BLOCK.clear();
        UNIVERSAL_GROWTHS.clear();
        for (IBlockGrowth config : growths) {
            Collection<TickSource> sources = config.getTickSources();
            for (TickSource s : sources) {
                Object group;
                Iterable<? extends Block> owners = config.getOwners();
                if (owners == null) {
                    group = UNIVERSAL_GROWTHS.computeIfAbsent(s, e -> new HashSet());
                    group.add(config);
                    continue;
                }
                group = GROWTH_FOR_BLOCK.computeIfAbsent(s, e -> Maps.newIdentityHashMap());
                config.getOwners().forEach(arg_0 -> BlockGrowthHandler.lambda$parse$6((Map)group, config, arg_0));
            }
        }
    }

    private void writeToFile(ConfigurableBlockGrowth obj, FileWriter writer) {
        DataResult r = ConfigurableBlockGrowth.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)obj);
        r.result().ifPresent(a -> GSON.toJson((JsonElement)this.sortJson(a.getAsJsonObject()), (Appendable)writer));
    }

    private JsonObject sortJson(JsonObject jsonObject) {
        try {
            TreeMap<String, JsonElement> joToMap = new TreeMap<String, JsonElement>();
            jsonObject.entrySet().forEach(e -> {
                JsonElement j = (JsonElement)e.getValue();
                if (j instanceof JsonObject) {
                    JsonObject jo = (JsonObject)j;
                    j = this.sortJson(jo);
                }
                joToMap.put((String)e.getKey(), j);
            });
            JsonObject sortedJSON = new JsonObject();
            joToMap.forEach((arg_0, arg_1) -> ((JsonObject)sortedJSON).add(arg_0, arg_1));
            return sortedJSON;
        }
        catch (Exception exception) {
            return jsonObject;
        }
    }

    private static /* synthetic */ void lambda$parse$6(Map group, IBlockGrowth config, Block b) {
        group.computeIfAbsent(b, k -> new HashSet()).add(config);
    }
}

