/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil_types;

import com.ordana.immersive_weathering.blocks.soil_types.ModFarmlandBlock;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SandyFarmlandBlock
extends ModFarmlandBlock
implements Fallable {
    public SandyFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ModBlocks.SANDY_DIRT.get().m_49966_() : super.m_5573_(context);
    }

    @Override
    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BlockState cropState;
        if (serverLevel.m_45524_(blockPos.m_7494_(), 0) >= 9 && (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61423_) == 7 && (cropState = serverLevel.m_8055_(blockPos.m_7494_())).m_204336_(ModTags.SAND_SOIL_CROP)) {
            for (int j = 0; j < 10; ++j) {
                cropState.m_222972_(serverLevel, blockPos.m_7494_(), randomSource);
            }
        }
        int i = (Integer)blockState.m_61143_((Property)f_53243_);
        if (!SandyFarmlandBlock.isNearWater((LevelReader)serverLevel, blockPos) && !serverLevel.m_46758_(blockPos.m_7494_())) {
            if (i > 0) {
                serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!SandyFarmlandBlock.isUnderCrops((BlockGetter)serverLevel, blockPos)) {
                SandyFarmlandBlock.turnToDirt(blockState, (Level)serverLevel, blockPos);
            }
        } else if (i < 7) {
            serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public static boolean isNearWater(LevelReader level, BlockPos pos) {
        BlockPos blockPos;
        Iterator var2 = BlockPos.m_121940_((BlockPos)pos.m_7918_(-2, 0, -2), (BlockPos)pos.m_7918_(2, 1, 2)).iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!level.m_6425_(blockPos = (BlockPos)var2.next()).m_205070_(FluidTags.f_13131_));
        return true;
    }

    @Override
    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float f) {
        if (!level.f_46443_ && level.f_46441_.m_188501_() < f - 0.5f && entity instanceof LivingEntity && (entity instanceof Player || level.m_46469_().m_46207_(GameRules.f_46132_)) && entity.m_20205_() * entity.m_20205_() * entity.m_20206_() > 0.512f) {
            SandyFarmlandBlock.turnToDirt(state, level, pos);
        }
        super.m_142072_(level, state, pos, entity, f);
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (SandyFarmlandBlock.isFree(level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_()) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
            this.falling(fallingBlockEntity);
        }
        if (!state.m_60710_((LevelReader)level, pos)) {
            SandyFarmlandBlock.turnToDirt(state, (Level)level, pos);
        }
    }

    public static void turnToDirt(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, SandyFarmlandBlock.m_49897_((BlockState)state, (BlockState)ModBlocks.SANDY_DIRT.get().m_152465_(state), (LevelAccessor)level, (BlockPos)pos));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        level.m_186460_(pos, (Block)this, this.getDelayAfterPlace());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.m_186460_(pos, (Block)this, this.getDelayAfterPlace());
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void falling(FallingBlockEntity entity) {
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public static boolean isFree(BlockState state) {
        return state.m_60795_() || state.m_204336_(BlockTags.f_13076_) || state.m_278721_() || state.m_247087_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos blockPos;
        if (random.m_188503_(16) == 0 && SandyFarmlandBlock.isFree(level.m_8055_(blockPos = pos.m_7495_()))) {
            ParticleUtils.m_272037_((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state));
        }
    }

    public int getDustColor(BlockState state, BlockGetter level, BlockPos pos) {
        return -16777216;
    }
}

