/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.snowy;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.util.TemperatureManager;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public interface Snowy {
    public static final Supplier<BiMap<Block, Block>> NORMAL_TO_SNOWY = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_50069_, (Object)ModBlocks.SNOWY_STONE.get()).put((Object)Blocks.f_50635_, (Object)ModBlocks.SNOWY_STONE_STAIRS.get()).put((Object)Blocks.f_50404_, (Object)ModBlocks.SNOWY_STONE_SLAB.get()).put((Object)ModBlocks.STONE_WALL.get(), (Object)ModBlocks.SNOWY_STONE_WALL.get()).put((Object)Blocks.f_50652_, (Object)ModBlocks.SNOWY_COBBLESTONE.get()).put((Object)Blocks.f_50157_, (Object)ModBlocks.SNOWY_COBBLESTONE_STAIRS.get()).put((Object)Blocks.f_50409_, (Object)ModBlocks.SNOWY_COBBLESTONE_SLAB.get()).put((Object)Blocks.f_50274_, (Object)ModBlocks.SNOWY_COBBLESTONE_WALL.get()).put((Object)Blocks.f_50222_, (Object)ModBlocks.SNOWY_STONE_BRICKS.get()).put((Object)Blocks.f_50225_, (Object)ModBlocks.SNOWY_CHISELED_STONE_BRICKS.get()).put((Object)Blocks.f_50194_, (Object)ModBlocks.SNOWY_STONE_BRICK_STAIRS.get()).put((Object)Blocks.f_50411_, (Object)ModBlocks.SNOWY_STONE_BRICK_SLAB.get()).put((Object)Blocks.f_50609_, (Object)ModBlocks.SNOWY_STONE_BRICK_WALL.get());
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> SNOWY_TO_NORMAL = Suppliers.memoize(() -> NORMAL_TO_SNOWY.get().inverse());

    public static Optional<BlockState> getSnowy(BlockState state) {
        return Snowy.getSnowy(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getUnSnowy(BlockState state) {
        return Snowy.getUnSnowy(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getUnSnowy(Block block) {
        return Optional.ofNullable((Block)SNOWY_TO_NORMAL.get().get((Object)block));
    }

    public static Optional<Block> getSnowy(Block block) {
        return Optional.ofNullable((Block)NORMAL_TO_SNOWY.get().get((Object)block));
    }

    default public boolean interactWithPlayer(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        Optional<BlockState> unSnowy = Snowy.getUnSnowy(state);
        if (unSnowy.isPresent() && item instanceof ShovelItem) {
            level.m_5594_(player, pos, SoundEvents.f_12474_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50125_.m_49966_()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                level.m_46597_(pos, unSnowy.get());
                if (!player.m_7500_() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)new ItemStack((ItemLike)Items.f_42452_));
                }
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return true;
        }
        return false;
    }

    default public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        Optional<BlockState> unSnowy = Snowy.getUnSnowy(state);
        if (!unSnowy.isPresent()) {
            return;
        }
        for (Direction dir : Direction.values()) {
            if (level.m_45517_(LightLayer.BLOCK, pos.m_121945_(dir)) <= 11) continue;
            level.m_46597_(pos, unSnowy.get());
            return;
        }
        if (!level.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_144279_) && TemperatureManager.canSnowMelt(pos, (Level)level)) {
            level.m_46597_(pos, unSnowy.get());
        }
    }

    default public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        Optional<BlockState> unSnowy = Snowy.getUnSnowy(state);
        BlockState neighborState = level.m_8055_(neighborPos);
        if (neighborState.m_60819_().m_205070_(FluidTags.f_13131_) || neighborState.m_60819_().m_205070_(FluidTags.f_13132_) && unSnowy.isPresent()) {
            level.m_46597_(pos, unSnowy.get());
            level.m_5594_(null, pos, SoundEvents.f_12474_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (neighborState.m_60819_().m_205070_(FluidTags.f_13132_)) {
                level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

