/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.mossy;

import com.ordana.immersive_weathering.blocks.mossy.Mossable;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.PatchSpreader;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class MossSpreader
implements PatchSpreader<Mossable.MossLevel> {
    public static MossSpreader INSTANCE = new MossSpreader();

    @Override
    public Class<Mossable.MossLevel> getType() {
        return Mossable.MossLevel.class;
    }

    @Override
    public double getInterestForDirection(Level level, BlockPos pos) {
        return CommonConfigs.MOSS_INTERESTS_FOR_FACE.get();
    }

    @Override
    public double getDisjointGrowthChance(Level level, BlockPos pos) {
        return CommonConfigs.MOSS_PATCHINESS.get();
    }

    @Override
    public double getUnWeatherableChance(Level level, BlockPos pos) {
        return CommonConfigs.MOSS_IMMUNE_CHANCE.get();
    }

    @Override
    public PatchSpreader.WeatheringAgent getWeatheringEffect(BlockState state, Level level, BlockPos pos) {
        if (state.m_204336_(ModTags.MOSSY)) {
            return PatchSpreader.WeatheringAgent.WEATHER;
        }
        return PatchSpreader.WeatheringAgent.NONE;
    }

    @Override
    public PatchSpreader.WeatheringAgent getHighInfluenceWeatheringEffect(BlockState state, Level level, BlockPos pos) {
        FluidState fluid = state.m_60819_();
        if (fluid.m_205070_(FluidTags.f_13132_)) {
            return PatchSpreader.WeatheringAgent.PREVENT_WEATHERING;
        }
        if (state.m_204336_(ModTags.MOSS_SOURCE) || fluid.m_205070_(FluidTags.f_13131_)) {
            return PatchSpreader.WeatheringAgent.WEATHER;
        }
        return PatchSpreader.WeatheringAgent.NONE;
    }

    @Override
    public boolean needsAirToSpread(Level level, BlockPos pos) {
        return CommonConfigs.MOSS_NEEDS_AIR.get();
    }

    static void growNeighbors(ServerLevel level, RandomSource random, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos targetPos;
            BlockState targetBlock;
            Block block;
            if (!(random.m_188501_() > 0.5f) || !((block = (targetBlock = level.m_8055_(targetPos = pos.m_121945_(direction))).m_60734_()) instanceof Mossable)) continue;
            Mossable mossable = (Mossable)block;
            Optional<BlockState> newState = mossable.getNextMossy(targetBlock);
            newState.ifPresent(s -> level.m_46597_(targetPos, s));
        }
    }
}

