/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util.modifier;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.util.modifier.IModifierOperation;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_4926;

public enum ModifierOperation implements IModifierOperation
{
    ADD_BASE_EARLY(IModifierOperation.Phase.BASE, 0, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> base + values.stream().reduce(0.0, Double::sum))),
    MULTIPLY_BASE_ADDITIVE(IModifierOperation.Phase.BASE, 100, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> current + base * values.stream().reduce(0.0, Double::sum))),
    MULTIPLY_BASE_MULTIPLICATIVE(IModifierOperation.Phase.BASE, 200, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            value *= 1.0 + v;
        }
        return value;
    })),
    ADD_BASE_LATE(IModifierOperation.Phase.BASE, 300, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            value += v;
        }
        return value;
    })),
    MIN_BASE(IModifierOperation.Phase.BASE, 400, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            value = Math.max(v, value);
        }
        return value;
    })),
    MAX_BASE(IModifierOperation.Phase.BASE, 500, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            value = Math.min(v, value);
        }
        return value;
    })),
    SET_BASE(IModifierOperation.Phase.BASE, 600, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v;
            value = v = ((Double)iterator.next()).doubleValue();
        }
        return value;
    })),
    MULTIPLY_TOTAL_ADDITIVE(IModifierOperation.Phase.TOTAL, 0, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> current + base * values.stream().reduce(0.0, Double::sum))),
    MULTIPLY_TOTAL_MULTIPLICATIVE(IModifierOperation.Phase.TOTAL, 100, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            value *= 1.0 + v;
        }
        return value;
    })),
    ADD_TOTAL_LATE(IModifierOperation.Phase.TOTAL, 200, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v;
            value = v = ((Double)iterator.next()).doubleValue();
        }
        return value;
    })),
    MIN_TOTAL(IModifierOperation.Phase.TOTAL, 300, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            value = Math.max(v, value);
        }
        return value;
    })),
    MAX_TOTAL(IModifierOperation.Phase.TOTAL, 400, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            value = Math.min(v, value);
        }
        return value;
    })),
    SET_TOTAL(IModifierOperation.Phase.TOTAL, 500, (class_4926.class_4932<List<Double>, Double, Double, Double>)((class_4926.class_4932)(values, base, current) -> {
        double value = current;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double v;
            value = v = ((Double)iterator.next()).doubleValue();
        }
        return value;
    }));

    public static final SerializableData DATA;
    private final IModifierOperation.Phase phase;
    private final int order;
    private final class_4926.class_4932<List<Double>, Double, Double, Double> function;

    private ModifierOperation(IModifierOperation.Phase phase, int order, class_4926.class_4932<List<Double>, Double, Double, Double> function) {
        this.phase = phase;
        this.order = order;
        this.function = function;
    }

    @Override
    public IModifierOperation.Phase getPhase() {
        return this.phase;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public SerializableData getData() {
        return DATA;
    }

    @Override
    public double apply(class_1297 entity, List<SerializableData.Instance> instances, double base, double current) {
        return (Double)this.function.apply(instances.stream().map(instance -> {
            double value = 0.0;
            if (instance.isPresent("resource")) {
                PowerType powerType;
                PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity);
                if (!component.hasPower(powerType = (PowerType)instance.get("resource"))) {
                    value = (Double)instance.get("value");
                } else {
                    Object p = component.getPower(powerType);
                    if (p instanceof VariableIntPower) {
                        VariableIntPower vip = (VariableIntPower)p;
                        value = vip.getValue();
                    } else if (p instanceof CooldownPower) {
                        CooldownPower cp = (CooldownPower)p;
                        value = cp.getRemainingTicks();
                    }
                }
            } else {
                value = (Double)instance.get("value");
            }
            if (instance.isPresent("modifier")) {
                List modifiers = (List)instance.get("modifier");
                value = ModifierUtil.applyModifiers(entity, modifiers, value);
            }
            return value;
        }).collect(Collectors.toList()), (Object)base, (Object)current);
    }

    static {
        DATA = new SerializableData().add("value", SerializableDataTypes.DOUBLE).add("resource", ApoliDataTypes.POWER_TYPE, null).add("modifier", Modifier.LIST_TYPE, null);
    }
}

