/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import java.util.Optional;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class PowerLootCondition
implements class_5341 {
    public static final class_5342 TYPE = new class_5342((class_5335)new Serializer());
    private final class_2960 powerId;
    private final class_2960 powerSourceId;

    private PowerLootCondition(class_2960 powerId) {
        this.powerId = powerId;
        this.powerSourceId = null;
    }

    private PowerLootCondition(class_2960 powerId, class_2960 powerSourceId) {
        this.powerId = powerId;
        this.powerSourceId = powerSourceId;
    }

    public class_5342 method_29325() {
        return TYPE;
    }

    public boolean test(class_47 lootContext) {
        Optional optionalPowerHolderComponent = PowerHolderComponent.KEY.maybeGet(lootContext.method_296(class_181.field_1226));
        if (optionalPowerHolderComponent.isPresent()) {
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)optionalPowerHolderComponent.get();
            PowerType powerType = PowerTypeRegistry.get(this.powerId);
            if (this.powerSourceId != null) {
                return powerHolderComponent.hasPower(powerType, this.powerSourceId);
            }
            return powerHolderComponent.hasPower(powerType);
        }
        return false;
    }

    public static class Serializer
    implements class_5335<PowerLootCondition> {
        public void toJson(JsonObject jsonObject, PowerLootCondition powerLootCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("power", powerLootCondition.powerId.toString());
            if (powerLootCondition.powerSourceId != null) {
                jsonObject.addProperty("source", powerLootCondition.powerSourceId.toString());
            }
        }

        public PowerLootCondition fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            class_2960 power = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"power"));
            if (jsonObject.has("source")) {
                class_2960 source = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"source"));
                return new PowerLootCondition(power, source);
            }
            return new PowerLootCondition(power);
        }
    }
}

