/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.power.factory.condition.item.EnchantmentCondition;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class ItemConditions {
    public static void register() {
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, stack) -> data.getBoolean("value")));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.ITEM_CONDITIONS), (data, stack) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(stack))));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.ITEM_CONDITIONS), (data, stack) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(stack))));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("food"), new SerializableData(), (data, stack) -> stack.method_19267()));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("ingredient"), new SerializableData().add("ingredient", SerializableDataTypes.INGREDIENT), (data, stack) -> ((class_1856)data.get("ingredient")).method_8093(stack)));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("armor_value"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, stack) -> {
            int armor = 0;
            if (stack.method_7909() instanceof class_1738) {
                class_1738 item = (class_1738)stack.method_7909();
                armor = item.method_7687();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(armor, data.getInt("compare_to"));
        }));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("harvest_level"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, stack) -> {
            int harvestLevel = 0;
            if (stack.method_7909() instanceof class_1831) {
                class_1831 item = (class_1831)stack.method_7909();
                harvestLevel = item.method_8022().method_8024();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(harvestLevel, data.getInt("compare_to"));
        }));
        ItemConditions.register(EnchantmentCondition.getFactory());
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("meat"), new SerializableData(), (data, stack) -> stack.method_19267() && stack.method_7909().method_19264().method_19232()));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("nbt"), new SerializableData().add("nbt", SerializableDataTypes.NBT), (data, stack) -> class_2512.method_10687((class_2520)((class_2520)data.get("nbt")), (class_2520)stack.method_7969(), (boolean)true)));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("fireproof"), new SerializableData(), (data, stack) -> stack.method_7909().method_24358()));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("enchantable"), new SerializableData(), (data, stack) -> !stack.method_7923()));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("power_count"), new SerializableData().add("slot", SerializableDataTypes.EQUIPMENT_SLOT, null).add("compare_to", SerializableDataTypes.INT).add("comparison", ApoliDataTypes.COMPARISON), (data, stack) -> {
            int totalCount = 0;
            if (data.isPresent("slot")) {
                totalCount = StackPowerUtil.getPowers(stack, (class_1304)data.get("slot")).size();
            } else {
                for (class_1304 slot : class_1304.values()) {
                    totalCount += StackPowerUtil.getPowers(stack, slot).size();
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(totalCount, data.getInt("compare_to"));
        }));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("has_power"), new SerializableData().add("slot", SerializableDataTypes.EQUIPMENT_SLOT, null).add("power", SerializableDataTypes.IDENTIFIER), (data, stack) -> {
            class_2960 power = data.getId("power");
            if (data.isPresent("slot")) {
                return StackPowerUtil.getPowers(stack, (class_1304)data.get("slot")).stream().anyMatch(p -> p.powerId.equals((Object)power));
            }
            for (class_1304 slot : class_1304.values()) {
                if (!StackPowerUtil.getPowers(stack, slot).stream().anyMatch(p -> p.powerId.equals((Object)power))) continue;
                return true;
            }
            return false;
        }));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("empty"), new SerializableData(), (data, stack) -> stack.method_7960()));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("amount"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, stack) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(stack.method_7947(), data.getInt("compare_to"))));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("is_damageable"), new SerializableData(), (data, stack) -> stack.method_7963()));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("durability"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, stack) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(stack.method_7936() - stack.method_7919(), data.getInt("compare_to"))));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("relative_durability"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, stack) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare((float)(stack.method_7936() - stack.method_7919()) / (float)stack.method_7936(), data.getFloat("compare_to"))));
        ItemConditions.register(new ConditionFactory<class_1799>(Apoli.identifier("is_equippable"), new SerializableData().add("equipment_slot", SerializableDataTypes.EQUIPMENT_SLOT), (data, stack) -> class_1308.method_32326((class_1799)stack) == data.get("equipment_slot")));
    }

    private static void register(ConditionFactory<class_1799> conditionFactory) {
        class_2378.method_10230(ApoliRegistries.ITEM_CONDITION, (class_2960)conditionFactory.getSerializerId(), conditionFactory);
    }
}

