/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.MovingEntity;
import io.github.apace100.apoli.access.SubmergableEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.mixin.EntityAccessor;
import io.github.apace100.apoli.power.ClimbingPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeReference;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.power.factory.condition.DistanceFromCoordinatesConditionRegistry;
import io.github.apace100.apoli.power.factory.condition.entity.BlockCollisionCondition;
import io.github.apace100.apoli.power.factory.condition.entity.BrightnessCondition;
import io.github.apace100.apoli.power.factory.condition.entity.ElytraFlightPossibleCondition;
import io.github.apace100.apoli.power.factory.condition.entity.ExposedToSunCondition;
import io.github.apace100.apoli.power.factory.condition.entity.InventoryCondition;
import io.github.apace100.apoli.power.factory.condition.entity.PowerCondition;
import io.github.apace100.apoli.power.factory.condition.entity.RaycastCondition;
import io.github.apace100.apoli.power.factory.condition.entity.ResourceCondition;
import io.github.apace100.apoli.power.factory.condition.entity.ScoreboardCondition;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.Shape;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.ladysnake.pal.PlayerAbility;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1959;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8490;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;

public class EntityConditions {
    public static void register() {
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, entity) -> data.getBoolean("value")));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.ENTITY_CONDITIONS), (data, entity) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(entity))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.ENTITY_CONDITIONS), (data, entity) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(entity))));
        EntityConditions.register(BlockCollisionCondition.getFactory());
        EntityConditions.register(BrightnessCondition.getFactory());
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("daytime"), new SerializableData(), (data, entity) -> entity.method_37908().method_8532() % 24000L < 13000L));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("time_of_day"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.method_37908().method_8532() % 24000L, data.getInt("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("fall_flying"), new SerializableData(), (data, entity) -> entity instanceof class_1309 && ((class_1309)entity).method_6128()));
        EntityConditions.register(ExposedToSunCondition.getFactory());
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("in_rain"), new SerializableData(), (data, entity) -> ((EntityAccessor)entity).callIsBeingRainedOn()));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("invisible"), new SerializableData(), (data, entity) -> entity.method_5767()));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("on_fire"), new SerializableData(), (data, entity) -> entity.method_5809()));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("exposed_to_sky"), new SerializableData(), (data, entity) -> {
            class_2338 blockPos = entity.method_5854() instanceof class_1690 ? class_2338.method_49637((double)entity.method_23317(), (double)Math.round(entity.method_23318()), (double)entity.method_23321()).method_10084() : class_2338.method_49637((double)entity.method_23317(), (double)Math.round(entity.method_23318()), (double)entity.method_23321());
            return entity.method_37908().method_8311(blockPos);
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("sneaking"), new SerializableData(), (data, entity) -> entity.method_5715()));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("sprinting"), new SerializableData(), (data, entity) -> entity.method_5624()));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("power_active"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE), (data, entity) -> ((PowerTypeReference)data.get("power")).isActive((class_1297)entity)));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("status_effect"), new SerializableData().add("effect", SerializableDataTypes.STATUS_EFFECT).add("min_amplifier", SerializableDataTypes.INT, (Object)0).add("max_amplifier", SerializableDataTypes.INT, (Object)Integer.MAX_VALUE).add("min_duration", SerializableDataTypes.INT, (Object)0).add("max_duration", SerializableDataTypes.INT, (Object)Integer.MAX_VALUE), (data, entity) -> {
            class_1309 living;
            class_1291 effect = (class_1291)data.get("effect");
            if (entity instanceof class_1309 && (living = (class_1309)entity).method_6059(effect)) {
                class_1293 instance = living.method_6112(effect);
                return instance.method_5584() <= data.getInt("max_duration") && instance.method_5584() >= data.getInt("min_duration") && instance.method_5578() <= data.getInt("max_amplifier") && instance.method_5578() >= data.getInt("min_amplifier");
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("submerged_in"), new SerializableData().add("fluid", SerializableDataTypes.FLUID_TAG), (data, entity) -> ((SubmergableEntity)entity).isSubmergedInLoosely((class_6862<class_3611>)((class_6862)data.get("fluid")))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("fluid_height"), new SerializableData().add("fluid", SerializableDataTypes.FLUID_TAG).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.DOUBLE), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(((SubmergableEntity)entity).getFluidHeightLoosely((class_6862<class_3611>)((class_6862)data.get("fluid"))), data.getDouble("compare_to"))));
        EntityConditions.register(PowerCondition.getFactory());
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("food_level"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof class_1657) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((class_1657)entity).method_7344().method_7586(), data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("saturation_level"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, entity) -> {
            if (entity instanceof class_1657) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((class_1657)entity).method_7344().method_7589(), data.getFloat("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("on_block"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null), (data, entity) -> entity.method_24828() && (!data.isPresent("block_condition") || ((ConditionFactory.Instance)data.get("block_condition")).test(new class_2694((class_4538)entity.method_37908(), class_2338.method_49637((double)entity.method_23317(), (double)(entity.method_5829().field_1322 - 0.5000001), (double)entity.method_23321()), true)))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("equipped_item"), new SerializableData().add("equipment_slot", SerializableDataTypes.EQUIPMENT_SLOT).add("item_condition", ApoliDataTypes.ITEM_CONDITION), (data, entity) -> entity instanceof class_1309 && ((ConditionFactory.Instance)data.get("item_condition")).test(((class_1309)entity).method_6118((class_1304)data.get("equipment_slot")))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("attribute"), new SerializableData().add("attribute", SerializableDataTypes.ATTRIBUTE).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.DOUBLE), (data, entity) -> {
            class_1309 living;
            class_1324 attributeInstance;
            double attrValue = 0.0;
            if (entity instanceof class_1309 && (attributeInstance = (living = (class_1309)entity).method_5996((class_1320)data.get("attribute"))) != null) {
                attrValue = attributeInstance.method_6194();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(attrValue, data.getDouble("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("swimming"), new SerializableData(), (data, entity) -> entity.method_5681()));
        EntityConditions.register(ResourceCondition.getFactory());
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("air"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.method_5669(), data.getInt("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("in_block"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION), (data, entity) -> ((ConditionFactory.Instance)data.get("block_condition")).test(new class_2694((class_4538)entity.method_37908(), entity.method_24515(), true))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("block_in_radius"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION).add("radius", SerializableDataTypes.INT).add("shape", SerializableDataType.enumValue(Shape.class), (Object)Shape.CUBE).add("compare_to", SerializableDataTypes.INT, (Object)1).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL), (data, entity) -> {
            Predicate blockCondition = (Predicate)data.get("block_condition");
            int stopAt = -1;
            Comparison comparison = (Comparison)((Object)((Object)data.get("comparison")));
            int compareTo = data.getInt("compare_to");
            switch (comparison) {
                case EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: {
                    stopAt = compareTo + 1;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    stopAt = compareTo;
                }
            }
            int count = 0;
            for (class_2338 pos : Shape.getPositions(entity.method_24515(), (Shape)((Object)((Object)data.get("shape"))), data.getInt("radius"))) {
                if (!blockCondition.test(new class_2694((class_4538)entity.method_37908(), pos, true)) || ++count != stopAt) continue;
                break;
            }
            return comparison.compare(count, compareTo);
        }));
        DistanceFromCoordinatesConditionRegistry.registerEntityCondition(EntityConditions::register);
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("dimension"), new SerializableData().add("dimension", SerializableDataTypes.IDENTIFIER), (data, entity) -> entity.method_37908().method_27983() == class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)data.getId("dimension"))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("xp_levels"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof class_1657) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((class_1657)entity).field_7520, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("xp_points"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof class_1657) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((class_1657)entity).field_7495, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("health"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity instanceof class_1309 ? (double)((class_1309)entity).method_6032() : 0.0, data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("relative_health"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, entity) -> {
            float health = 0.0f;
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                health = living.method_6032() / living.method_6063();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(health, data.getFloat("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("biome"), new SerializableData().add("biome", SerializableDataTypes.IDENTIFIER, null).add("biomes", SerializableDataTypes.IDENTIFIERS, null).add("condition", ApoliDataTypes.BIOME_CONDITION, null), (data, entity) -> {
            class_6880 biomeEntry = entity.method_37908().method_23753(entity.method_24515());
            class_1959 biome = (class_1959)biomeEntry.comp_349();
            ConditionFactory.Instance condition = (ConditionFactory.Instance)data.get("condition");
            if (data.isPresent("biome") || data.isPresent("biomes")) {
                class_2960 biomeId = entity.method_37908().method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
                if (data.isPresent("biome") && biomeId.equals((Object)data.getId("biome"))) {
                    return condition == null || condition.test(biomeEntry);
                }
                if (data.isPresent("biomes") && ((List)data.get("biomes")).contains(biomeId)) {
                    return condition == null || condition.test(biomeEntry);
                }
                return false;
            }
            return condition == null || condition.test(biomeEntry);
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("entity_type"), new SerializableData().add("entity_type", SerializableDataTypes.ENTITY_TYPE), (data, entity) -> entity.method_5864() == data.get("entity_type")));
        EntityConditions.register(ScoreboardCondition.getFactory());
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("command"), new SerializableData().add("command", SerializableDataTypes.STRING).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> {
            MinecraftServer server = entity.method_37908().method_8503();
            if (server != null) {
                boolean validOutput = !(entity instanceof class_3222) || ((class_3222)entity).field_13987 != null;
                class_2168 source = new class_2168((class_2165)(Apoli.config.executeCommand.showOutput && validOutput ? entity : class_2165.field_17395), entity.method_19538(), entity.method_5802(), entity.method_37908() instanceof class_3218 ? (class_3218)entity.method_37908() : null, Apoli.config.executeCommand.permissionLevel, entity.method_5477().getString(), entity.method_5476(), server, entity);
                int output = server.method_3734().method_44252(source, data.getString("command"));
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(output, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("predicate"), new SerializableData().add("predicate", SerializableDataTypes.IDENTIFIER), (data, entity) -> {
            class_5341 lootCondition;
            MinecraftServer server = entity.method_37908().method_8503();
            if (server != null && (lootCondition = (class_5341)server.method_3857().getElement(class_8490.field_44496, (class_2960)data.get("predicate"))) != null) {
                class_8567 lootContextParameterSet = new class_8567.class_8568((class_3218)entity.method_37908()).method_51874(class_181.field_24424, (Object)entity.method_19538()).method_51877(class_181.field_1226, entity).method_51875(class_173.field_20761);
                class_47 lootContext = new class_47.class_48(lootContextParameterSet).method_309(null);
                return lootCondition.test((Object)lootContext);
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("fall_distance"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.field_6017, data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("collided_horizontally"), new SerializableData(), (data, entity) -> entity.field_5976));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("in_block_anywhere"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)1), (data, entity) -> {
            Predicate blockCondition = (Predicate)data.get("block_condition");
            int stopAt = -1;
            Comparison comparison = (Comparison)((Object)((Object)data.get("comparison")));
            int compareTo = data.getInt("compare_to");
            switch (comparison) {
                case EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case NOT_EQUAL: {
                    stopAt = compareTo + 1;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    stopAt = compareTo;
                }
            }
            int count = 0;
            class_238 box = entity.method_5829();
            class_2338 blockPos = class_2338.method_49637((double)(box.field_1323 + 0.001), (double)(box.field_1322 + 0.001), (double)(box.field_1321 + 0.001));
            class_2338 blockPos2 = class_2338.method_49637((double)(box.field_1320 - 0.001), (double)(box.field_1325 - 0.001), (double)(box.field_1324 - 0.001));
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int i = blockPos.method_10263(); i <= blockPos2.method_10263() && count < stopAt; ++i) {
                for (int j = blockPos.method_10264(); j <= blockPos2.method_10264() && count < stopAt; ++j) {
                    for (int k = blockPos.method_10260(); k <= blockPos2.method_10260() && count < stopAt; ++k) {
                        mutable.method_10103(i, j, k);
                        if (!blockCondition.test(new class_2694((class_4538)entity.method_37908(), (class_2338)mutable, true))) continue;
                        ++count;
                    }
                }
            }
            return comparison.compare(count, compareTo);
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("entity_group"), new SerializableData().add("group", SerializableDataTypes.ENTITY_GROUP), (data, entity) -> entity instanceof class_1309 && ((class_1309)entity).method_6046() == data.get("group")));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("in_tag"), new SerializableData().add("tag", SerializableDataTypes.ENTITY_TAG), (data, entity) -> entity.method_5864().method_40124().method_40220((class_6862)data.get("tag"))));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("climbing"), new SerializableData(), (data, entity) -> {
            if (entity instanceof class_1309 && ((class_1309)entity).method_6101()) {
                return true;
            }
            if (PowerHolderComponent.hasPower(entity, ClimbingPower.class)) {
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("tamed"), new SerializableData(), (data, entity) -> {
            if (entity instanceof class_1321) {
                return ((class_1321)entity).method_6181();
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("using_item"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null), (data, entity) -> {
            class_1309 living;
            if (entity instanceof class_1309 && (living = (class_1309)entity).method_6115()) {
                ConditionFactory.Instance condition = (ConditionFactory.Instance)data.get("item_condition");
                if (condition != null) {
                    class_1268 activeHand = living.method_6058();
                    class_1799 handStack = living.method_5998(activeHand);
                    return condition.test(handStack);
                }
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("moving"), new SerializableData(), (data, entity) -> ((MovingEntity)entity).isMoving()));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("enchantment"), new SerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT).add("calculation", SerializableDataTypes.STRING, (Object)"sum"), (data, entity) -> {
            int value = 0;
            if (entity instanceof class_1309) {
                String calculation;
                class_1309 le = (class_1309)entity;
                class_1887 enchantment = (class_1887)data.get("enchantment");
                switch (calculation = data.getString("calculation")) {
                    case "sum": {
                        for (class_1799 stack : enchantment.method_8185(le).values()) {
                            value += class_1890.method_8225((class_1887)enchantment, (class_1799)stack);
                        }
                        break;
                    }
                    case "max": {
                        value = class_1890.method_8203((class_1887)enchantment, (class_1309)le);
                        break;
                    }
                    default: {
                        Apoli.LOGGER.error("Error in \"enchantment\" entity condition, undefined calculation type: \"" + calculation + "\".");
                    }
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(value, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("riding"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null), (data, entity) -> {
            if (entity.method_5765()) {
                if (data.isPresent("bientity_condition")) {
                    Predicate condition = (Predicate)data.get("bientity_condition");
                    class_1297 vehicle = entity.method_5854();
                    return condition.test(new class_3545(entity, (Object)vehicle));
                }
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("riding_root"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null), (data, entity) -> {
            if (entity.method_5765()) {
                if (data.isPresent("bientity_condition")) {
                    Predicate condition = (Predicate)data.get("bientity_condition");
                    class_1297 vehicle = entity.method_5668();
                    return condition.test(new class_3545(entity, (Object)vehicle));
                }
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("riding_recursive"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)1), (data, entity) -> {
            int count = 0;
            if (entity.method_5765()) {
                Predicate cond = (Predicate)data.get("bientity_condition");
                for (class_1297 vehicle = entity.method_5854(); vehicle != null; vehicle = vehicle.method_5854()) {
                    if (cond != null && !cond.test(new class_3545(entity, (Object)vehicle))) continue;
                    ++count;
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(count, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("living"), new SerializableData(), (data, entity) -> entity instanceof class_1309));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("passenger"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)1), (data, entity) -> {
            int count = 0;
            if (entity.method_5782()) {
                if (data.isPresent("bientity_condition")) {
                    Predicate condition = (Predicate)data.get("bientity_condition");
                    count = (int)entity.method_5685().stream().filter(e -> condition.test(new class_3545(e, entity))).count();
                } else {
                    count = entity.method_5685().size();
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(count, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("passenger_recursive"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)1), (data, entity) -> {
            int count = 0;
            if (entity.method_5782()) {
                if (data.isPresent("bientity_condition")) {
                    Predicate condition = (Predicate)data.get("bientity_condition");
                    List passengers = entity.method_5685();
                    count = (int)passengers.stream().flatMap(class_1297::method_24204).filter(e -> condition.test(new class_3545(e, entity))).count();
                } else {
                    count = (int)entity.method_5685().stream().flatMap(class_1297::method_24204).count();
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(count, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("nbt"), new SerializableData().add("nbt", SerializableDataTypes.NBT), (data, entity) -> {
            class_2487 nbt = new class_2487();
            entity.method_5647(nbt);
            return class_2512.method_10687((class_2520)((class_2520)data.get("nbt")), (class_2520)nbt, (boolean)true);
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("exists"), new SerializableData(), (data, entity) -> entity != null));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("creative_flying"), new SerializableData(), (data, entity) -> entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7479));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("power_type"), new SerializableData().add("power_type", ApoliDataTypes.POWER_TYPE), (data, entity) -> {
            PowerTypeReference powerTypeReference = (PowerTypeReference)data.get("power_type");
            PowerType powerType = powerTypeReference.getReferencedPowerType();
            return PowerHolderComponent.KEY.maybeGet(entity).map(phc -> phc.getPowerTypes(true).contains(powerType)).orElse(false);
        }));
        EntityConditions.register(new ConditionFactory<class_1297>(Apoli.identifier("ability"), new SerializableData().add("ability", ApoliDataTypes.PLAYER_ABILITY), (data, entity) -> {
            if (entity instanceof class_1657 && !entity.method_37908().field_9236) {
                return ((PlayerAbility)data.get("ability")).isEnabledFor((class_1657)entity);
            }
            return false;
        }));
        EntityConditions.register(RaycastCondition.getFactory());
        EntityConditions.register(ElytraFlightPossibleCondition.getFactory());
        EntityConditions.register(InventoryCondition.getFactory());
    }

    private static void register(ConditionFactory<class_1297> conditionFactory) {
        class_2378.method_10230(ApoliRegistries.ENTITY_CONDITION, (class_2960)conditionFactory.getSerializerId(), conditionFactory);
    }
}

