/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.Shape;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2694;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_638;

public class DistanceFromCoordinatesConditionRegistry {
    private static final ArrayList<Object> previousWarnings = new ArrayList();

    private static void warnOnce(String warning, Object key) {
        if (!previousWarnings.contains(key)) {
            previousWarnings.add(key);
            Apoli.LOGGER.warn(warning);
        }
    }

    private static void warnOnce(String warning) {
        DistanceFromCoordinatesConditionRegistry.warnOnce(warning, warning);
    }

    private static <T> T warnCouldNotGetObject(String object, String from, T assumption) {
        DistanceFromCoordinatesConditionRegistry.warnOnce("Could not retrieve " + object + " from " + from + " for distance_from_spawn condition, assuming " + String.valueOf(assumption) + " for condition.");
        return assumption;
    }

    private static String[] getAliases() {
        return new String[]{"distance_from_spawn", "distance_from_coordinates"};
    }

    private static SerializableData getSerializableData(String alias) {
        return new SerializableData().add("reference", SerializableDataTypes.STRING, (Object)(alias.equals("distance_from_coordinates") ? "world_origin" : "world_spawn")).add("offset", SerializableDataTypes.VECTOR, (Object)new class_243(0.0, 0.0, 0.0)).add("coordinates", SerializableDataTypes.VECTOR, (Object)new class_243(0.0, 0.0, 0.0)).add("ignore_x", SerializableDataTypes.BOOLEAN, (Object)false).add("ignore_y", SerializableDataTypes.BOOLEAN, (Object)false).add("ignore_z", SerializableDataTypes.BOOLEAN, (Object)false).add("shape", SerializableDataType.enumValue(Shape.class), (Object)Shape.CUBE).add("scale_reference_to_dimension", SerializableDataTypes.BOOLEAN, (Object)true).add("scale_distance_to_dimension", SerializableDataTypes.BOOLEAN, (Object)false).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.DOUBLE).add("result_on_wrong_dimension", SerializableDataTypes.BOOLEAN, null).add("round_to_digit", SerializableDataTypes.INT, null);
    }

    private static boolean compareOutOfBounds(Comparison comparison) {
        return comparison == Comparison.NOT_EQUAL || comparison == Comparison.GREATER_THAN || comparison == Comparison.GREATER_THAN_OR_EQUAL;
    }

    private static boolean testCondition(SerializableData.Instance data, class_2694 block, class_1297 entity) {
        double zDistance;
        class_1937 world;
        class_243 pos;
        boolean scaleReferenceToDimension = data.getBoolean("scale_reference_to_dimension");
        boolean setResultOnWrongDimension = data.isPresent("result_on_wrong_dimension");
        boolean resultOnWrongDimension = setResultOnWrongDimension && data.getBoolean("result_on_wrong_dimension");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (block != null) {
            class_2338 blockPos = block.method_11683();
            pos = new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
            class_4538 worldView = block.method_11679();
            if (!(worldView instanceof class_1937)) {
                return DistanceFromCoordinatesConditionRegistry.warnCouldNotGetObject("world", "block", DistanceFromCoordinatesConditionRegistry.compareOutOfBounds((Comparison)((Object)data.get("comparison"))));
            }
            world = (class_1937)worldView;
        } else {
            pos = entity.method_19538();
            world = entity.method_5770();
        }
        double currentDimensionCoordinateScale = world.method_8597().comp_646();
        switch (data.getString("reference")) {
            case "player_spawn": 
            case "player_natural_spawn": {
                if (entity instanceof class_1657) {
                    DistanceFromCoordinatesConditionRegistry.warnOnce("Used reference '" + data.getString("reference") + "' which is not implemented yet, defaulting to world spawn.");
                }
                if (entity == null) {
                    DistanceFromCoordinatesConditionRegistry.warnOnce("Used entity-condition-only reference point in block condition, defaulting to world spawn.");
                }
            }
            case "world_spawn": {
                class_2338 spawnPos;
                if (setResultOnWrongDimension && world.method_27983() != class_1937.field_25179) {
                    return resultOnWrongDimension;
                }
                if (world instanceof class_638) {
                    spawnPos = ((class_638)world).method_43126();
                } else if (world instanceof class_3218) {
                    spawnPos = ((class_3218)world).method_43126();
                } else {
                    return DistanceFromCoordinatesConditionRegistry.warnCouldNotGetObject("world with spawn position", block != null ? "block" : "entity", DistanceFromCoordinatesConditionRegistry.compareOutOfBounds((Comparison)((Object)data.get("comparison"))));
                }
                x = spawnPos.method_10263();
                y = spawnPos.method_10264();
                z = spawnPos.method_10260();
                break;
            }
        }
        class_243 coords = (class_243)data.get("coordinates");
        class_243 offset = (class_243)data.get("offset");
        y += coords.field_1351 + offset.field_1351;
        if (scaleReferenceToDimension && ((x += coords.field_1352 + offset.field_1352) != 0.0 || (z += coords.field_1350 + offset.field_1350) != 0.0)) {
            if (currentDimensionCoordinateScale == 0.0) {
                return DistanceFromCoordinatesConditionRegistry.compareOutOfBounds((Comparison)((Object)data.get("comparison")));
            }
            x /= currentDimensionCoordinateScale;
            z /= currentDimensionCoordinateScale;
        }
        double xDistance = data.getBoolean("ignore_x") ? 0.0 : Math.abs(pos.method_10216() - x);
        double yDistance = data.getBoolean("ignore_y") ? 0.0 : Math.abs(pos.method_10214() - y);
        double d = zDistance = data.getBoolean("ignore_z") ? 0.0 : Math.abs(pos.method_10215() - z);
        if (data.getBoolean("scale_distance_to_dimension")) {
            xDistance *= currentDimensionCoordinateScale;
            zDistance *= currentDimensionCoordinateScale;
        }
        double distance = Shape.getDistance((Shape)((Object)data.get("shape")), xDistance, yDistance, zDistance);
        if (data.isPresent("round_to_digit")) {
            distance = new BigDecimal(distance).setScale(data.getInt("round_to_digit"), RoundingMode.HALF_UP).doubleValue();
        }
        return ((Comparison)((Object)data.get("comparison"))).compare(distance, data.getDouble("compare_to"));
    }

    public static void registerBlockCondition(Consumer<ConditionFactory<class_2694>> registryFunction) {
        for (String alias : DistanceFromCoordinatesConditionRegistry.getAliases()) {
            registryFunction.accept(new ConditionFactory<class_2694>(Apoli.identifier(alias), DistanceFromCoordinatesConditionRegistry.getSerializableData(alias), (data, block) -> DistanceFromCoordinatesConditionRegistry.testCondition(data, block, null)));
        }
    }

    public static void registerEntityCondition(Consumer<ConditionFactory<class_1297>> registryFunction) {
        for (String alias : DistanceFromCoordinatesConditionRegistry.getAliases()) {
            registryFunction.accept(new ConditionFactory<class_1297>(Apoli.identifier(alias), DistanceFromCoordinatesConditionRegistry.getSerializableData(alias), (data, entity) -> DistanceFromCoordinatesConditionRegistry.testCondition(data, null, entity)));
        }
    }
}

