/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.power.factory.condition.DistanceFromCoordinatesConditionRegistry;
import io.github.apace100.apoli.power.factory.condition.block.LightLevelCondition;
import io.github.apace100.apoli.power.factory.condition.block.MaterialCondition;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2402;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class BlockConditions {
    public static void register() {
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, block) -> data.getBoolean("value")));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.BLOCK_CONDITIONS), (data, block) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(block))));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.BLOCK_CONDITIONS), (data, block) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(block))));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("offset"), new SerializableData().add("condition", ApoliDataTypes.BLOCK_CONDITION).add("x", SerializableDataTypes.INT, (Object)0).add("y", SerializableDataTypes.INT, (Object)0).add("z", SerializableDataTypes.INT, (Object)0), (data, block) -> ((ConditionFactory.Instance)data.get("condition")).test(new class_2694(block.method_11679(), block.method_11683().method_10069(data.getInt("x"), data.getInt("y"), data.getInt("z")), true))));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("height"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, block) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(block.method_11683().method_10264(), data.getInt("compare_to"))));
        DistanceFromCoordinatesConditionRegistry.registerBlockCondition(BlockConditions::register);
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("block"), new SerializableData().add("block", SerializableDataTypes.BLOCK), (data, block) -> block.method_11681().method_27852((class_2248)data.get("block"))));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("in_tag"), new SerializableData().add("tag", SerializableDataTypes.BLOCK_TAG), (data, block) -> {
            if (block == null || block.method_11681() == null) {
                return false;
            }
            return block.method_11681().method_26164((class_6862)data.get("tag"));
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("adjacent"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT).add("adjacent_condition", ApoliDataTypes.BLOCK_CONDITION), (data, block) -> {
            ConditionFactory.Instance adjacentCondition = (ConditionFactory.Instance)data.get("adjacent_condition");
            int adjacent = 0;
            for (class_2350 d : class_2350.values()) {
                if (!adjacentCondition.test(new class_2694(block.method_11679(), block.method_11683().method_10093(d), true))) continue;
                ++adjacent;
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(adjacent, data.getInt("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("replacable"), new SerializableData(), (data, block) -> block.method_11681().method_45474()));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("attachable"), new SerializableData(), (data, block) -> {
            for (class_2350 d : class_2350.values()) {
                class_2338 adjacent = block.method_11683().method_10093(d);
                if (!block.method_11679().method_8320(adjacent).method_26206((class_1922)block.method_11679(), block.method_11683(), d.method_10153())) continue;
                return true;
            }
            return false;
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("fluid"), new SerializableData().add("fluid_condition", ApoliDataTypes.FLUID_CONDITION), (data, block) -> ((ConditionFactory.Instance)data.get("fluid_condition")).test(block.method_11679().method_8316(block.method_11683()))));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("movement_blocking"), new SerializableData(), (data, block) -> block.method_11681().method_51366() && !block.method_11681().method_26220((class_1922)block.method_11679(), block.method_11683()).method_1110()));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("light_blocking"), new SerializableData(), (data, block) -> block.method_11681().method_26225()));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("water_loggable"), new SerializableData(), (data, block) -> block.method_11681().method_26204() instanceof class_2402));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("exposed_to_sky"), new SerializableData(), (data, block) -> block.method_11679().method_8311(block.method_11683())));
        BlockConditions.register(LightLevelCondition.getFactory());
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("block_state"), new SerializableData().add("property", SerializableDataTypes.STRING).add("comparison", ApoliDataTypes.COMPARISON, null).add("compare_to", SerializableDataTypes.INT, null).add("value", SerializableDataTypes.BOOLEAN, null).add("enum", SerializableDataTypes.STRING, null), (data, block) -> {
            class_2680 state = block.method_11681();
            Collection properties = state.method_28501();
            String desiredPropertyName = data.getString("property");
            class_2769 property = null;
            for (class_2769 p : properties) {
                if (!p.method_11899().equals(desiredPropertyName)) continue;
                property = p;
                break;
            }
            if (property != null) {
                Comparable value = state.method_11654(property);
                if (data.isPresent("enum") && value instanceof Enum) {
                    return ((Enum)((Object)value)).name().equalsIgnoreCase(data.getString("enum"));
                }
                if (data.isPresent("value") && value instanceof Boolean) {
                    return ((Boolean)value).booleanValue() == data.getBoolean("value");
                }
                if (data.isPresent("comparison") && data.isPresent("compare_to") && value instanceof Integer) {
                    return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Integer)value).intValue(), data.getInt("compare_to"));
                }
                return true;
            }
            return false;
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("block_entity"), new SerializableData(), (data, block) -> block.method_11680() != null));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("nbt"), new SerializableData().add("nbt", SerializableDataTypes.NBT), (data, block) -> {
            class_2487 nbt = new class_2487();
            if (block.method_11680() != null) {
                nbt = block.method_11680().method_38242();
            }
            return class_2512.method_10687((class_2520)((class_2487)data.get("nbt")), (class_2520)nbt, (boolean)true);
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("slipperiness"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, block) -> {
            class_2680 state = block.method_11681();
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(state.method_26204().method_9499(), data.getFloat("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("blast_resistance"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, block) -> {
            class_2680 state = block.method_11681();
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(state.method_26204().method_9520(), data.getFloat("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Apoli.identifier("hardness"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, block) -> {
            class_2680 state = block.method_11681();
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(state.method_26204().method_36555(), data.getFloat("compare_to"));
        }));
        BlockConditions.register(MaterialCondition.getFactory());
    }

    private static void register(ConditionFactory<class_2694> conditionFactory) {
        class_2378.method_10230(ApoliRegistries.BLOCK_CONDITION, (class_2960)conditionFactory.getSerializerId(), conditionFactory);
    }
}

