/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.InventoryPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.InventoryUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1297;

public class DropInventoryAction {
    public static void action(SerializableData.Instance data, class_1297 entity) {
        InventoryUtil.InventoryType inventoryType = (InventoryUtil.InventoryType)((Object)data.get("inventory_type"));
        switch (inventoryType) {
            case INVENTORY: {
                InventoryUtil.dropInventory(data, entity, null);
                break;
            }
            case POWER: {
                if (!data.isPresent("power")) {
                    return;
                }
                PowerHolderComponent.KEY.maybeGet((Object)entity).ifPresent(powerHolderComponent -> {
                    PowerType targetPowerType = (PowerType)data.get("power");
                    Object targetPower = powerHolderComponent.getPower(targetPowerType);
                    if (!(targetPower instanceof InventoryPower)) {
                        return;
                    }
                    InventoryPower inventoryPower = (InventoryPower)targetPower;
                    InventoryUtil.dropInventory(data, entity, inventoryPower);
                });
            }
        }
    }

    public static ActionFactory<class_1297> getFactory() {
        return new ActionFactory<class_1297>(Apoli.identifier("drop_inventory"), new SerializableData().add("inventory_type", ApoliDataTypes.INVENTORY_TYPE, (Object)InventoryUtil.InventoryType.INVENTORY).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("slots", ApoliDataTypes.ITEM_SLOTS, null).add("slot", ApoliDataTypes.ITEM_SLOT, null).add("power", ApoliDataTypes.POWER_TYPE, null).add("throw_randomly", SerializableDataTypes.BOOLEAN, (Object)false).add("retain_ownership", SerializableDataTypes.BOOLEAN, (Object)true).add("amount", SerializableDataTypes.INT, (Object)0), DropInventoryAction::action);
    }
}

