/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.MutableItemStack;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.action.item.HolderAction;
import io.github.apace100.apoli.power.factory.action.meta.AndAction;
import io.github.apace100.apoli.power.factory.action.meta.ChanceAction;
import io.github.apace100.apoli.power.factory.action.meta.ChoiceAction;
import io.github.apace100.apoli.power.factory.action.meta.DelayAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseListAction;
import io.github.apace100.apoli.power.factory.action.meta.NothingAction;
import io.github.apace100.apoli.power.factory.action.meta.SideAction;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.class_117;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1885;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_47;
import net.minecraft.class_5819;
import net.minecraft.class_60;
import net.minecraft.class_8490;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;

public class ItemActions {
    public static void register() {
        ItemActions.register(AndAction.getFactory(ApoliDataTypes.ITEM_ACTIONS));
        ItemActions.register(ChanceAction.getFactory(ApoliDataTypes.ITEM_ACTION));
        ItemActions.register(IfElseAction.getFactory(ApoliDataTypes.ITEM_ACTION, ApoliDataTypes.ITEM_CONDITION, class_3545::method_15441));
        ItemActions.register(ChoiceAction.getFactory(ApoliDataTypes.ITEM_ACTION));
        ItemActions.register(IfElseListAction.getFactory(ApoliDataTypes.ITEM_ACTION, ApoliDataTypes.ITEM_CONDITION, class_3545::method_15441));
        ItemActions.register(DelayAction.getFactory(ApoliDataTypes.ITEM_ACTION));
        ItemActions.register(NothingAction.getFactory());
        ItemActions.register(SideAction.getFactory(ApoliDataTypes.ITEM_ACTION, worldAndStack -> !((class_1937)worldAndStack.method_15442()).field_9236));
        ItemActions.register(new ActionFactory<class_3545<class_1937, class_1799>>(Apoli.identifier("consume"), new SerializableData().add("amount", SerializableDataTypes.INT, (Object)1), (data, worldAndStack) -> ((class_1799)worldAndStack.method_15441()).method_7934(data.getInt("amount"))));
        ItemActions.register(new ActionFactory<class_3545<class_1937, class_1799>>(Apoli.identifier("modify"), new SerializableData().add("modifier", SerializableDataTypes.IDENTIFIER), (data, worldAndStack) -> {
            MinecraftServer server = ((class_1937)worldAndStack.method_15442()).method_8503();
            if (server != null) {
                class_2960 id = data.getId("modifier");
                class_60 lootManager = server.method_3857();
                class_117 lootFunction = (class_117)lootManager.getElement(class_8490.field_44497, id);
                if (lootFunction == null) {
                    Apoli.LOGGER.info("Unknown item modifier used in `modify` action: " + String.valueOf(id));
                    return;
                }
                class_3218 serverWorld = server.method_30002();
                class_1799 stack = (class_1799)worldAndStack.method_15441();
                class_8567 lootContextParameterSet = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)new class_243(0.0, 0.0, 0.0)).method_51875(class_173.field_20761);
                class_47 lootContext = new class_47.class_48(lootContextParameterSet).method_309(null);
                class_1799 newStack = (class_1799)lootFunction.apply((Object)stack, (Object)lootContext);
                ((MutableItemStack)stack).setFrom(newStack);
            }
        }));
        ItemActions.register(new ActionFactory<class_3545<class_1937, class_1799>>(Apoli.identifier("damage"), new SerializableData().add("amount", SerializableDataTypes.INT, (Object)1).add("ignore_unbreaking", SerializableDataTypes.BOOLEAN, (Object)false), (data, worldAndStack) -> {
            if (((class_1799)worldAndStack.method_15441()).method_7963()) {
                int i;
                int amount = data.getInt("amount");
                if (amount > 0 && !data.getBoolean("ignore_unbreaking")) {
                    i = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)((class_1799)worldAndStack.method_15441()));
                    int j = 0;
                    for (int k = 0; i > 0 && k < amount; ++k) {
                        if (!class_1885.method_8176((class_1799)((class_1799)worldAndStack.method_15441()), (int)i, (class_5819)((class_1937)worldAndStack.method_15442()).field_9229)) continue;
                        ++j;
                    }
                    if ((amount -= j) <= 0) {
                        return;
                    }
                }
                i = ((class_1799)worldAndStack.method_15441()).method_7919() + amount;
                ((class_1799)worldAndStack.method_15441()).method_7974(i);
                if (i >= ((class_1799)worldAndStack.method_15441()).method_7936()) {
                    ((class_1799)worldAndStack.method_15441()).method_7934(1);
                    ((class_1799)worldAndStack.method_15441()).method_7974(0);
                }
            }
        }));
        ItemActions.register(new ActionFactory<class_3545<class_1937, class_1799>>(Apoli.identifier("merge_nbt"), new SerializableData().add("nbt", SerializableDataTypes.STRING), (data, worldAndStack) -> {
            String nbtString = (String)data.get("nbt");
            try {
                class_2487 nbt = new class_2522(new StringReader(nbtString)).method_10727();
                ((class_1799)worldAndStack.method_15441()).method_7948().method_10543(nbt);
            }
            catch (CommandSyntaxException e) {
                Apoli.LOGGER.error("Failed `merge_nbt` item action due to malformed nbt string: \"" + nbtString + "\"");
            }
        }));
        ItemActions.register(new ActionFactory<class_3545<class_1937, class_1799>>(Apoli.identifier("remove_enchantment"), new SerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT, null).add("enchantments", SerializableDataType.list((SerializableDataType)SerializableDataTypes.ENCHANTMENT), null).add("levels", SerializableDataTypes.INT, null).add("reset_repair_cost", SerializableDataTypes.BOOLEAN, (Object)false), (data, worldAndStack) -> {
            class_1799 stack = (class_1799)worldAndStack.method_15441();
            if (!stack.method_7985()) {
                return;
            }
            LinkedList enchs = new LinkedList();
            data.ifPresent("enchantment", enchs::add);
            data.ifPresent("enchantments", enchs::addAll);
            int levels = -1;
            if (data.isPresent("levels")) {
                levels = data.getInt("levels");
            }
            LinkedHashMap<class_1887, Integer> enchants = class_1890.method_8222((class_1799)stack);
            if (enchs.size() > 0) {
                for (class_1887 ench : enchs) {
                    int newLevel;
                    if (!enchants.containsKey(ench)) continue;
                    int n = newLevel = levels == -1 ? 0 : (Integer)enchants.get(ench) - data.getInt("levels");
                    if (newLevel <= 0) {
                        enchants.remove(ench);
                        continue;
                    }
                    enchants.put(ench, newLevel);
                }
            } else {
                LinkedHashMap<class_1887, Integer> newEnchants = new LinkedHashMap<class_1887, Integer>();
                for (class_1887 e : enchants.keySet()) {
                    int newLevel = levels == -1 ? 0 : (Integer)enchants.get(e) - data.getInt("levels");
                    if (newLevel <= 0) continue;
                    newEnchants.put(e, newLevel);
                }
                enchants = newEnchants;
            }
            class_1890.method_8214((Map)enchants, (class_1799)stack);
            if (data.getBoolean("reset_repair_cost") && !stack.method_7942()) {
                stack.method_7927(0);
            }
        }));
        ItemActions.register(HolderAction.getFactory());
    }

    private static void register(ActionFactory<class_3545<class_1937, class_1799>> actionFactory) {
        class_2378.method_10230(ApoliRegistries.ITEM_ACTION, (class_2960)actionFactory.getSerializerId(), actionFactory);
    }
}

