/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2481;
import net.minecraft.class_2520;

public class TogglePower
extends Power
implements Active {
    private boolean isActive;
    private final boolean shouldRetainState;
    private Active.Key key;

    public TogglePower(PowerType<?> type, class_1309 entity) {
        this(type, entity, false, true);
    }

    public TogglePower(PowerType<?> type, class_1309 entity, boolean activeByDefault) {
        this(type, entity, activeByDefault, true);
    }

    public TogglePower(PowerType<?> type, class_1309 entity, boolean activeByDefault, boolean shouldRetainState) {
        super(type, entity);
        this.shouldRetainState = shouldRetainState;
        this.isActive = activeByDefault;
    }

    @Override
    public boolean shouldTick() {
        return !this.shouldRetainState && this.conditions.size() > 0;
    }

    @Override
    public boolean shouldTickWhenInactive() {
        return true;
    }

    @Override
    public void tick() {
        if (!super.isActive() && this.isActive) {
            this.isActive = false;
            PowerHolderComponent.syncPower((class_1297)this.entity, this.type);
        }
    }

    @Override
    public void onUse() {
        this.isActive = !this.isActive;
        PowerHolderComponent.syncPower((class_1297)this.entity, this.type);
    }

    @Override
    public boolean isActive() {
        return this.isActive && super.isActive();
    }

    @Override
    public class_2520 toTag() {
        return class_2481.method_23234((boolean)this.isActive);
    }

    @Override
    public void fromTag(class_2520 tag) {
        this.isActive = ((class_2481)tag).method_10698() > 0;
    }

    @Override
    public Active.Key getKey() {
        return this.key;
    }

    @Override
    public void setKey(Active.Key key) {
        this.key = key;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("toggle"), new SerializableData().add("active_by_default", SerializableDataTypes.BOOLEAN, (Object)true).add("retain_state", SerializableDataTypes.BOOLEAN, (Object)true).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()), data -> (type, player) -> {
            TogglePower power = new TogglePower((PowerType<?>)type, (class_1309)player, data.getBoolean("active_by_default"), data.getBoolean("retain_state"));
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition();
    }
}

