/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.NightVisionPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2481;
import net.minecraft.class_2520;

public class ToggleNightVisionPower
extends NightVisionPower
implements Active {
    private boolean isActive;
    private Active.Key key;

    public ToggleNightVisionPower(PowerType<?> type, class_1309 entity) {
        this(type, entity, 1.0f, true);
    }

    public ToggleNightVisionPower(PowerType<?> type, class_1309 entity, float strength, boolean activeByDefault) {
        super(type, entity, strength);
        this.isActive = activeByDefault;
    }

    @Override
    public void onUse() {
        this.isActive = !this.isActive;
        PowerHolderComponent.syncPower((class_1297)this.entity, this.type);
    }

    @Override
    public boolean isActive() {
        return this.isActive && super.isActive();
    }

    @Override
    public class_2520 toTag() {
        return class_2481.method_23234((boolean)this.isActive);
    }

    @Override
    public void fromTag(class_2520 tag) {
        if (tag instanceof class_2481) {
            this.isActive = ((class_2481)tag).method_10698() > 0;
        }
    }

    @Override
    public Active.Key getKey() {
        return this.key;
    }

    @Override
    public void setKey(Active.Key key) {
        this.key = key;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("toggle_night_vision"), new SerializableData().add("active_by_default", SerializableDataTypes.BOOLEAN, (Object)false).add("strength", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()), data -> (type, entity) -> {
            ToggleNightVisionPower power = new ToggleNightVisionPower((PowerType<?>)type, (class_1309)entity, data.getFloat("strength"), data.getBoolean("active_by_default"));
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition();
    }
}

