/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3545;

public class StartingEquipmentPower
extends Power {
    private final List<class_1799> itemStacks = new LinkedList<class_1799>();
    private final HashMap<Integer, class_1799> slottedStacks = new HashMap();
    private boolean recurrent;

    public StartingEquipmentPower(PowerType<?> type, class_1309 entity) {
        super(type, entity);
    }

    public void setRecurrent(boolean recurrent) {
        this.recurrent = recurrent;
    }

    public void addStack(class_1799 stack) {
        this.itemStacks.add(stack);
    }

    public void addStack(int slot, class_1799 stack) {
        this.slottedStacks.put(slot, stack);
    }

    @Override
    public void onGained() {
        this.giveStacks();
    }

    @Override
    public void onRespawn() {
        if (this.recurrent) {
            this.giveStacks();
        }
    }

    private void giveStacks() {
        this.slottedStacks.forEach((slot, stack) -> {
            if (this.entity instanceof class_1657) {
                class_1657 player = (class_1657)this.entity;
                class_1661 inventory = player.method_31548();
                if (inventory.method_5438(slot.intValue()).method_7960()) {
                    inventory.method_5447(slot.intValue(), stack);
                } else {
                    player.method_7270(stack);
                }
            } else {
                this.entity.method_5775(stack);
            }
        });
        this.itemStacks.forEach(is -> {
            class_1799 copy = is.method_7972();
            if (this.entity instanceof class_1657) {
                class_1657 player = (class_1657)this.entity;
                player.method_7270(copy);
            } else {
                this.entity.method_5775(copy);
            }
        });
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("starting_equipment"), new SerializableData().add("stack", ApoliDataTypes.POSITIONED_ITEM_STACK, null).add("stacks", ApoliDataTypes.POSITIONED_ITEM_STACKS, null).add("recurrent", SerializableDataTypes.BOOLEAN, (Object)false), data -> (type, player) -> {
            StartingEquipmentPower power = new StartingEquipmentPower((PowerType<?>)type, (class_1309)player);
            if (data.isPresent("stack")) {
                class_3545 stack = (class_3545)data.get("stack");
                int slot = (Integer)stack.method_15442();
                if (slot > Integer.MIN_VALUE) {
                    power.addStack((Integer)stack.method_15442(), (class_1799)stack.method_15441());
                } else {
                    power.addStack((class_1799)stack.method_15441());
                }
            }
            if (data.isPresent("stacks")) {
                ((List)data.get("stacks")).forEach(integerItemStackPair -> {
                    int slot = (Integer)integerItemStackPair.method_15442();
                    if (slot > Integer.MIN_VALUE) {
                        power.addStack((Integer)integerItemStackPair.method_15442(), (class_1799)integerItemStackPair.method_15441());
                    } else {
                        power.addStack((class_1799)integerItemStackPair.method_15441());
                    }
                });
            }
            power.setRecurrent(data.getBoolean("recurrent"));
            return power;
        });
    }
}

