/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;

public class SelfActionOnKillPower
extends CooldownPower {
    private final Predicate<class_3545<class_1282, Float>> damageCondition;
    private final Predicate<class_1297> targetCondition;
    private final Consumer<class_1297> entityAction;

    public SelfActionOnKillPower(PowerType<?> type, class_1309 entity, int cooldownDuration, HudRender hudRender, Predicate<class_3545<class_1282, Float>> damageCondition, Consumer<class_1297> entityAction, Predicate<class_1297> targetCondition) {
        super(type, entity, cooldownDuration, hudRender);
        this.damageCondition = damageCondition;
        this.entityAction = entityAction;
        this.targetCondition = targetCondition;
    }

    public void onKill(class_1297 target, class_1282 damageSource, float damageAmount) {
        if ((this.targetCondition == null || this.targetCondition.test(target)) && (this.damageCondition == null || this.damageCondition.test((class_3545<class_1282, Float>)new class_3545((Object)damageSource, (Object)Float.valueOf(damageAmount)))) && this.canUse()) {
            this.entityAction.accept((class_1297)this.entity);
            this.use();
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("self_action_on_kill"), new SerializableData().add("entity_action", ApoliDataTypes.ENTITY_ACTION).add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("cooldown", SerializableDataTypes.INT, (Object)1).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER).add("target_condition", ApoliDataTypes.ENTITY_CONDITION, null), data -> (type, player) -> new SelfActionOnKillPower((PowerType<?>)type, (class_1309)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (ConditionFactory.Instance)data.get("damage_condition"), (ActionFactory.Instance)data.get("entity_action"), (ConditionFactory.Instance)data.get("target_condition"))).allowCondition();
    }
}

