/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

public class RestrictArmorPower
extends Power {
    private final HashMap<class_1304, Predicate<class_1799>> armorConditions;

    public RestrictArmorPower(PowerType<?> type, class_1309 entity, HashMap<class_1304, Predicate<class_1799>> armorConditions) {
        super(type, entity);
        this.armorConditions = armorConditions;
    }

    @Override
    public void onGained() {
        super.onGained();
        for (class_1304 slot : this.armorConditions.keySet()) {
            class_1799 equippedItem = this.entity.method_6118(slot);
            if (equippedItem.method_7960() || this.canEquip(equippedItem, slot)) continue;
            this.entity.method_5699(equippedItem, this.entity.method_18381(this.entity.method_18376()));
            this.entity.method_5673(slot, class_1799.field_8037);
        }
    }

    public boolean canEquip(class_1799 itemStack, class_1304 slot) {
        if (this.armorConditions.get(slot) == null) {
            return true;
        }
        return !this.armorConditions.get(slot).test(itemStack);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("restrict_armor"), new SerializableData().add("head", ApoliDataTypes.ITEM_CONDITION, null).add("chest", ApoliDataTypes.ITEM_CONDITION, null).add("legs", ApoliDataTypes.ITEM_CONDITION, null).add("feet", ApoliDataTypes.ITEM_CONDITION, null), data -> (type, player) -> {
            HashMap<class_1304, Predicate<class_1799>> restrictions = new HashMap<class_1304, Predicate<class_1799>>();
            if (data.isPresent("head")) {
                restrictions.put(class_1304.field_6169, (ConditionFactory.Instance)data.get("head"));
            }
            if (data.isPresent("chest")) {
                restrictions.put(class_1304.field_6174, (ConditionFactory.Instance)data.get("chest"));
            }
            if (data.isPresent("legs")) {
                restrictions.put(class_1304.field_6172, (ConditionFactory.Instance)data.get("legs"));
            }
            if (data.isPresent("feet")) {
                restrictions.put(class_1304.field_6166, (ConditionFactory.Instance)data.get("feet"));
            }
            return new RestrictArmorPower((PowerType<?>)type, (class_1309)player, restrictions);
        });
    }
}

