/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.HudRenderedVariableIntPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public class ResourcePower
extends HudRenderedVariableIntPower {
    private final Consumer<class_1297> actionOnMin;
    private final Consumer<class_1297> actionOnMax;

    public ResourcePower(PowerType<?> type, class_1309 entity, HudRender hudRender, int startValue, int min, int max, Consumer<class_1297> actionOnMin, Consumer<class_1297> actionOnMax) {
        super(type, entity, hudRender, startValue, min, max);
        this.actionOnMin = actionOnMin;
        this.actionOnMax = actionOnMax;
    }

    @Override
    public int setValue(int newValue) {
        int oldValue = this.currentValue;
        int actualNewValue = super.setValue(newValue);
        if (oldValue != actualNewValue) {
            if (this.actionOnMin != null && actualNewValue == this.min) {
                this.actionOnMin.accept((class_1297)this.entity);
            }
            if (this.actionOnMax != null && actualNewValue == this.max) {
                this.actionOnMax.accept((class_1297)this.entity);
            }
        }
        return actualNewValue;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("resource"), new SerializableData().add("min", SerializableDataTypes.INT).add("max", SerializableDataTypes.INT).addFunctionedDefault("start_value", SerializableDataTypes.INT, data -> data.getInt("min")).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER).add("min_action", ApoliDataTypes.ENTITY_ACTION, null).add("max_action", ApoliDataTypes.ENTITY_ACTION, null), data -> (type, player) -> new ResourcePower((PowerType<?>)type, (class_1309)player, (HudRender)data.get("hud_render"), data.getInt("start_value"), data.getInt("min"), data.getInt("max"), (ActionFactory.Instance)data.get("min_action"), (ActionFactory.Instance)data.get("max_action"))).allowCondition();
    }
}

