/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.factory.PowerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class PowerType<T extends Power> {
    private class_2960 identifier;
    private PowerFactory.Instance factory;
    private boolean isHidden = false;
    private String nameTranslationKey;
    private String descriptionTranslationKey;

    public PowerType(class_2960 id, PowerFactory.Instance factory) {
        this.identifier = id;
        this.factory = factory;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public PowerFactory.Instance getFactory() {
        return this.factory;
    }

    public PowerType setHidden() {
        this.isHidden = true;
        return this;
    }

    public void setTranslationKeys(String name, String description) {
        this.nameTranslationKey = name;
        this.descriptionTranslationKey = description;
    }

    public T create(class_1309 entity) {
        return (T)this.getFactory().apply(this, entity);
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isActive(class_1297 entity) {
        PowerHolderComponent component;
        if (entity instanceof class_1309 && this.identifier != null && (component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).hasPower(this)) {
            return ((Power)component.getPower(this)).isActive();
        }
        return false;
    }

    public T get(class_1297 entity) {
        if (entity instanceof class_1309) {
            PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity);
            return component.getPower(this);
        }
        return null;
    }

    public String getOrCreateNameTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "power." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".name";
        }
        return this.nameTranslationKey;
    }

    public class_5250 getName() {
        return class_2561.method_43471((String)this.getOrCreateNameTranslationKey());
    }

    public String getOrCreateDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null || this.descriptionTranslationKey.isEmpty()) {
            this.descriptionTranslationKey = "power." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".description";
        }
        return this.descriptionTranslationKey;
    }

    public class_5250 getDescription() {
        return class_2561.method_43471((String)this.getOrCreateDescriptionTranslationKey());
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PowerType)) {
            return false;
        }
        class_2960 id = ((PowerType)obj).getIdentifier();
        return this.identifier.equals((Object)id);
    }
}

