/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class Power {
    protected class_1309 entity;
    protected PowerType<?> type;
    private boolean shouldTick = false;
    private boolean shouldTickWhenInactive = false;
    protected List<Predicate<class_1297>> conditions;

    public Power(PowerType<?> type, class_1309 entity) {
        this.type = type;
        this.entity = entity;
        this.conditions = new LinkedList<Predicate<class_1297>>();
    }

    public Power addCondition(Predicate<class_1297> condition) {
        this.conditions.add(condition);
        return this;
    }

    protected void setTicking() {
        this.setTicking(false);
    }

    protected void setTicking(boolean evenWhenInactive) {
        this.shouldTick = true;
        this.shouldTickWhenInactive = evenWhenInactive;
    }

    public boolean shouldTick() {
        return this.shouldTick;
    }

    public boolean shouldTickWhenInactive() {
        return this.shouldTickWhenInactive;
    }

    public void tick() {
    }

    public void onGained() {
    }

    public void onLost() {
    }

    public void onAdded() {
    }

    public void onRemoved() {
    }

    public void onRespawn() {
    }

    public boolean isActive() {
        return this.conditions.stream().allMatch(condition -> condition.test(this.entity));
    }

    public class_2520 toTag() {
        return new class_2487();
    }

    public void fromTag(class_2520 tag) {
    }

    public PowerType<?> getType() {
        return this.type;
    }

    public static PowerFactory createSimpleFactory(BiFunction<PowerType, class_1309, Power> powerConstructor, class_2960 identifier) {
        return new PowerFactory(identifier, new SerializableData(), data -> powerConstructor::apply).allowCondition();
    }
}

